%------------------------------------------------------------------------------
% File     : ITP018^7 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 syntactic export of thm_2Ebinary__ieee_2Eneg__ulp.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Ebinary__ieee_2Eneg__ulp.p [Gau20]
%          : HL408501^7.p [TPAP]

% Status   : Theorem
% Rating   : 0.33 v9.0.0, 0.67 v8.2.0, 0.33 v8.1.0, 0.25 v7.5.0
% Syntax   : Number of formulae    : 19756 (5020 unt;7319 typ;   0 def)
%            Number of atoms       : 46845 (16665 equ;2229 cnn)
%            Maximal formula atoms :  912 (   3 avg)
%            Number of connectives : 313574 (2229   ~;1113   |;11257   &;287336   @)
%                                         (5200 <=>;6439  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  364 (   8 avg)
%            Number of types       :   20 (  19 usr)
%            Number of type conns  : 32694 (32694   >;   0   *;   0   +;   0  <<)
%            Number of symbols     : 2008 (2006 usr;  48 con; 0-11 aty)
%            Number of variables   : 70483 (4105   ^;47088   !;13840   ?;70483   :)
%                                         (5450  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP002^7.ax').
include('Axioms/ITP001/ITP003^7.ax').
include('Axioms/ITP001/ITP004^7.ax').
include('Axioms/ITP001/ITP005^7.ax').
include('Axioms/ITP001/ITP006^7.ax').
include('Axioms/ITP001/ITP007^7.ax').
include('Axioms/ITP001/ITP008^7.ax').
include('Axioms/ITP001/ITP009^7.ax').
include('Axioms/ITP001/ITP010^7.ax').
include('Axioms/ITP001/ITP011^7.ax').
include('Axioms/ITP001/ITP012^7.ax').
include('Axioms/ITP001/ITP013^7.ax').
include('Axioms/ITP001/ITP014^7.ax').
include('Axioms/ITP001/ITP015^7.ax').
include('Axioms/ITP001/ITP016^7.ax').
include('Axioms/ITP001/ITP017^7.ax').
include('Axioms/ITP001/ITP018^7.ax').
include('Axioms/ITP001/ITP019^7.ax').
include('Axioms/ITP001/ITP020^7.ax').
include('Axioms/ITP001/ITP021^7.ax').
include('Axioms/ITP001/ITP022^7.ax').
include('Axioms/ITP001/ITP023^7.ax').
include('Axioms/ITP001/ITP024^7.ax').
include('Axioms/ITP001/ITP025^7.ax').
include('Axioms/ITP001/ITP026^7.ax').
include('Axioms/ITP001/ITP027^7.ax').
include('Axioms/ITP001/ITP028^7.ax').
include('Axioms/ITP001/ITP029^7.ax').
include('Axioms/ITP001/ITP030^7.ax').
include('Axioms/ITP001/ITP031^7.ax').
include('Axioms/ITP001/ITP032^7.ax').
include('Axioms/ITP001/ITP033^7.ax').
include('Axioms/ITP001/ITP034^7.ax').
include('Axioms/ITP001/ITP035^7.ax').
include('Axioms/ITP001/ITP036^7.ax').
include('Axioms/ITP001/ITP037^7.ax').
include('Axioms/ITP001/ITP038^7.ax').
include('Axioms/ITP001/ITP039^7.ax').
include('Axioms/ITP001/ITP040^7.ax').
include('Axioms/ITP001/ITP041^7.ax').
include('Axioms/ITP001/ITP042^7.ax').
include('Axioms/ITP001/ITP043^7.ax').
include('Axioms/ITP001/ITP044^7.ax').
include('Axioms/ITP001/ITP045^7.ax').
include('Axioms/ITP001/ITP046^7.ax').
include('Axioms/ITP001/ITP047^7.ax').
include('Axioms/ITP001/ITP048^7.ax').
include('Axioms/ITP001/ITP049^7.ax').
include('Axioms/ITP001/ITP050^7.ax').
include('Axioms/ITP001/ITP051^7.ax').
include('Axioms/ITP001/ITP052^7.ax').
include('Axioms/ITP001/ITP053^7.ax').
include('Axioms/ITP001/ITP054^7.ax').
include('Axioms/ITP001/ITP055^7.ax').
include('Axioms/ITP001/ITP056^7.ax').
include('Axioms/ITP001/ITP057^7.ax').
include('Axioms/ITP001/ITP058^7.ax').
include('Axioms/ITP001/ITP059^7.ax').
include('Axioms/ITP001/ITP060^7.ax').
include('Axioms/ITP001/ITP061^7.ax').
include('Axioms/ITP001/ITP062^7.ax').
include('Axioms/ITP001/ITP063^7.ax').
include('Axioms/ITP001/ITP064^7.ax').
include('Axioms/ITP001/ITP065^7.ax').
include('Axioms/ITP001/ITP066^7.ax').
include('Axioms/ITP001/ITP067^7.ax').
include('Axioms/ITP001/ITP068^7.ax').
include('Axioms/ITP001/ITP069^7.ax').
include('Axioms/ITP001/ITP070^7.ax').
include('Axioms/ITP001/ITP071^7.ax').
include('Axioms/ITP001/ITP072^7.ax').
include('Axioms/ITP001/ITP073^7.ax').
include('Axioms/ITP001/ITP074^7.ax').
include('Axioms/ITP001/ITP075^7.ax').
include('Axioms/ITP001/ITP076^7.ax').
include('Axioms/ITP001/ITP077^7.ax').
include('Axioms/ITP001/ITP078^7.ax').
include('Axioms/ITP001/ITP079^7.ax').
include('Axioms/ITP001/ITP080^7.ax').
include('Axioms/ITP001/ITP081^7.ax').
include('Axioms/ITP001/ITP082^7.ax').
include('Axioms/ITP001/ITP083^7.ax').
include('Axioms/ITP001/ITP084^7.ax').
include('Axioms/ITP001/ITP085^7.ax').
include('Axioms/ITP001/ITP086^7.ax').
include('Axioms/ITP001/ITP087^7.ax').
include('Axioms/ITP001/ITP088^7.ax').
include('Axioms/ITP001/ITP089^7.ax').
include('Axioms/ITP001/ITP090^7.ax').
include('Axioms/ITP001/ITP091^7.ax').
include('Axioms/ITP001/ITP092^7.ax').
include('Axioms/ITP001/ITP093^7.ax').
include('Axioms/ITP001/ITP094^7.ax').
include('Axioms/ITP001/ITP095^7.ax').
include('Axioms/ITP001/ITP096^7.ax').
include('Axioms/ITP001/ITP097^7.ax').
include('Axioms/ITP001/ITP098^7.ax').
include('Axioms/ITP001/ITP099^7.ax').
include('Axioms/ITP001/ITP100^7.ax').
include('Axioms/ITP001/ITP101^7.ax').
include('Axioms/ITP001/ITP102^7.ax').
include('Axioms/ITP001/ITP103^7.ax').
include('Axioms/ITP001/ITP104^7.ax').
include('Axioms/ITP001/ITP105^7.ax').
include('Axioms/ITP001/ITP106^7.ax').
include('Axioms/ITP001/ITP107^7.ax').
include('Axioms/ITP001/ITP108^7.ax').
include('Axioms/ITP001/ITP109^7.ax').
include('Axioms/ITP001/ITP110^7.ax').
include('Axioms/ITP001/ITP111^7.ax').
include('Axioms/ITP001/ITP112^7.ax').
include('Axioms/ITP001/ITP113^7.ax').
include('Axioms/ITP001/ITP114^7.ax').
include('Axioms/ITP001/ITP116^7.ax').
include('Axioms/ITP001/ITP117^7.ax').
include('Axioms/ITP001/ITP118^7.ax').
include('Axioms/ITP001/ITP119^7.ax').
include('Axioms/ITP001/ITP120^7.ax').
include('Axioms/ITP001/ITP121^7.ax').
include('Axioms/ITP001/ITP123^7.ax').
include('Axioms/ITP001/ITP124^7.ax').
include('Axioms/ITP001/ITP126^7.ax').
include('Axioms/ITP001/ITP127^7.ax').
include('Axioms/ITP001/ITP128^7.ax').
include('Axioms/ITP001/ITP129^7.ax').
include('Axioms/ITP001/ITP130^7.ax').
include('Axioms/ITP001/ITP131^7.ax').
include('Axioms/ITP001/ITP132^7.ax').
include('Axioms/ITP001/ITP133^7.ax').
%------------------------------------------------------------------------------
thf(tyop_2Ebinary__ieee_2Eflags,type,
    tyop_2Ebinary__ieee_2Eflags: $tType ).

thf(tyop_2Ebinary__ieee_2Efloat,type,
    tyop_2Ebinary__ieee_2Efloat: $tType > $tType > $tType ).

thf(tyop_2Ebinary__ieee_2Efloat__compare,type,
    tyop_2Ebinary__ieee_2Efloat__compare: $tType ).

thf(tyop_2Ebinary__ieee_2Efloat__value,type,
    tyop_2Ebinary__ieee_2Efloat__value: $tType ).

thf(tyop_2Ebinary__ieee_2Efp__op,type,
    tyop_2Ebinary__ieee_2Efp__op: $tType > $tType > $tType ).

thf(tyop_2Ebinary__ieee_2Erounding,type,
    tyop_2Ebinary__ieee_2Erounding: $tType ).

thf(tyop_2Ebool_2Eitself,type,
    tyop_2Ebool_2Eitself: $tType > $tType ).

thf(tyop_2Efcp_2Ecart,type,
    tyop_2Efcp_2Ecart: $tType > $tType > $tType ).

thf(tyop_2Eind__type_2Erecspace,type,
    tyop_2Eind__type_2Erecspace: $tType > $tType ).

thf(tyop_2Einteger_2Eint,type,
    tyop_2Einteger_2Eint: $tType ).

thf(tyop_2Elist_2Elist,type,
    tyop_2Elist_2Elist: $tType > $tType ).

thf(tyop_2Emin_2Ebool,type,
    tyop_2Emin_2Ebool: $tType ).

thf(tyop_2Emin_2Efun,type,
    tyop_2Emin_2Efun: $tType > $tType > $tType ).

thf(tyop_2Enum_2Enum,type,
    tyop_2Enum_2Enum: $tType ).

thf(tyop_2Eone_2Eone,type,
    tyop_2Eone_2Eone: $tType ).

thf(tyop_2Eoption_2Eoption,type,
    tyop_2Eoption_2Eoption: $tType > $tType ).

thf(tyop_2Epair_2Eprod,type,
    tyop_2Epair_2Eprod: $tType > $tType > $tType ).

thf(tyop_2Erealax_2Ereal,type,
    tyop_2Erealax_2Ereal: $tType ).

thf(tyop_2Esum_2Esum,type,
    tyop_2Esum_2Esum: $tType > $tType > $tType ).

thf(c_2Ebool_2E_21,type,
    c_2Ebool_2E_21: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Earithmetic_2E_2B,type,
    c_2Earithmetic_2E_2B: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Epair_2E_2C,type,
    c_2Epair_2E_2C: 
      !>[A_27a: $tType,A_27b: $tType] : ( A_27a > A_27b > ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) ) ).

thf(c_2Earithmetic_2E_2D,type,
    c_2Earithmetic_2E_2D: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ereal_2E_2F,type,
    c_2Ereal_2E_2F: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Ebool_2E_2F_5C,type,
    c_2Ebool_2E_2F_5C: $o > $o > $o ).

thf(c_2Enum_2E0,type,
    c_2Enum_2E0: tyop_2Enum_2Enum ).

thf(c_2Eprim__rec_2E_3C,type,
    c_2Eprim__rec_2E_3C: tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o ).

thf(c_2Earithmetic_2E_3C_3D,type,
    c_2Earithmetic_2E_3C_3D: tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o ).

thf(c_2Emin_2E_3D,type,
    c_2Emin_2E_3D: 
      !>[A_27a: $tType] : ( A_27a > A_27a > $o ) ).

thf(c_2Emin_2E_3D_3D_3E,type,
    c_2Emin_2E_3D_3D_3E: $o > $o > $o ).

thf(c_2Ebool_2E_3F,type,
    c_2Ebool_2E_3F: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Emin_2E_40,type,
    c_2Emin_2E_40: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > A_27a ) ).

thf(c_2Einteger_2EABS,type,
    c_2Einteger_2EABS: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint ).

thf(c_2Ebool_2EARB,type,
    c_2Ebool_2EARB: 
      !>[A_27a: $tType] : A_27a ).

thf(c_2Earithmetic_2EBIT1,type,
    c_2Earithmetic_2EBIT1: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2EBIT2,type,
    c_2Earithmetic_2EBIT2: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Eind__type_2EBOTTOM,type,
    c_2Eind__type_2EBOTTOM: 
      !>[A_27a: $tType] : ( tyop_2Eind__type_2Erecspace @ A_27a ) ).

thf(c_2Ebool_2ECOND,type,
    c_2Ebool_2ECOND: 
      !>[A_27a: $tType] : ( $o > A_27a > A_27a > A_27a ) ).

thf(c_2Elist_2ECONS,type,
    c_2Elist_2ECONS: 
      !>[A_27a: $tType] : ( A_27a > ( tyop_2Elist_2Elist @ A_27a ) > ( tyop_2Elist_2Elist @ A_27a ) ) ).

thf(c_2Eind__type_2ECONSTR,type,
    c_2Eind__type_2ECONSTR: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > A_27a > ( tyop_2Enum_2Enum > ( tyop_2Eind__type_2Erecspace @ A_27a ) ) > ( tyop_2Eind__type_2Erecspace @ A_27a ) ) ).

thf(c_2Ebool_2EDATATYPE,type,
    c_2Ebool_2EDATATYPE: 
      !>[A_27a: $tType] : ( A_27a > $o ) ).

thf(c_2Epred__set_2EEMPTY,type,
    c_2Epred__set_2EEMPTY: 
      !>[A_27a: $tType] : ( A_27a > $o ) ).

thf(c_2Ebinary__ieee_2EEQ,type,
    c_2Ebinary__ieee_2EEQ: tyop_2Ebinary__ieee_2Efloat__compare ).

thf(c_2Earithmetic_2EEVEN,type,
    c_2Earithmetic_2EEVEN: tyop_2Enum_2Enum > $o ).

thf(c_2Elist_2EEXISTS,type,
    c_2Elist_2EEXISTS: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > ( tyop_2Elist_2Elist @ A_27a ) > $o ) ).

thf(c_2Earithmetic_2EEXP,type,
    c_2Earithmetic_2EEXP: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebool_2EF,type,
    c_2Ebool_2EF: $o ).

thf(c_2Ebinary__ieee_2EFP__Add,type,
    c_2Ebinary__ieee_2EFP__Add: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2EFP__Div,type,
    c_2Ebinary__ieee_2EFP__Div: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2EFP__Mul,type,
    c_2Ebinary__ieee_2EFP__Mul: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2EFP__MulAdd,type,
    c_2Ebinary__ieee_2EFP__MulAdd: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2EFP__MulSub,type,
    c_2Ebinary__ieee_2EFP__MulSub: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2EFP__Sqrt,type,
    c_2Ebinary__ieee_2EFP__Sqrt: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2EFP__Sub,type,
    c_2Ebinary__ieee_2EFP__Sub: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2EFloat,type,
    c_2Ebinary__ieee_2EFloat: tyop_2Erealax_2Ereal > tyop_2Ebinary__ieee_2Efloat__value ).

thf(c_2Epred__set_2EGSPEC,type,
    c_2Epred__set_2EGSPEC: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27b > ( tyop_2Epair_2Eprod @ A_27a @ $o ) ) > A_27a > $o ) ).

thf(c_2Ebinary__ieee_2EGT,type,
    c_2Ebinary__ieee_2EGT: tyop_2Ebinary__ieee_2Efloat__compare ).

thf(c_2Ecombin_2EI,type,
    c_2Ecombin_2EI: 
      !>[A_27a: $tType] : ( A_27a > A_27a ) ).

thf(c_2Ebool_2EIN,type,
    c_2Ebool_2EIN: 
      !>[A_27a: $tType] : ( A_27a > ( A_27a > $o ) > $o ) ).

thf(c_2Epred__set_2EINSERT,type,
    c_2Epred__set_2EINSERT: 
      !>[A_27a: $tType] : ( A_27a > ( A_27a > $o ) > A_27a > $o ) ).

thf(c_2Eintreal_2EINT__CEILING,type,
    c_2Eintreal_2EINT__CEILING: tyop_2Erealax_2Ereal > tyop_2Einteger_2Eint ).

thf(c_2Eintreal_2EINT__FLOOR,type,
    c_2Eintreal_2EINT__FLOOR: tyop_2Erealax_2Ereal > tyop_2Einteger_2Eint ).

thf(c_2Ewords_2EINT__MAX,type,
    c_2Ewords_2EINT__MAX: 
      !>[A_27a: $tType] : ( ( tyop_2Ebool_2Eitself @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ewords_2EINT__MIN,type,
    c_2Ewords_2EINT__MIN: 
      !>[A_27a: $tType] : ( ( tyop_2Ebool_2Eitself @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ebinary__ieee_2EInfinity,type,
    c_2Ebinary__ieee_2EInfinity: tyop_2Ebinary__ieee_2Efloat__value ).

thf(c_2Ecombin_2EK,type,
    c_2Ecombin_2EK: 
      !>[A_27a: $tType,A_27b: $tType] : ( A_27a > A_27b > A_27a ) ).

thf(c_2Ebool_2ELET,type,
    c_2Ebool_2ELET: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > A_27b ) > A_27a > A_27b ) ).

thf(c_2Ebinary__ieee_2ELT,type,
    c_2Ebinary__ieee_2ELT: tyop_2Ebinary__ieee_2Efloat__compare ).

thf(c_2Elist_2ENIL,type,
    c_2Elist_2ENIL: 
      !>[A_27a: $tType] : ( tyop_2Elist_2Elist @ A_27a ) ).

thf(c_2Eoption_2ENONE,type,
    c_2Eoption_2ENONE: 
      !>[A_27a: $tType] : ( tyop_2Eoption_2Eoption @ A_27a ) ).

thf(c_2Earithmetic_2ENUMERAL,type,
    c_2Earithmetic_2ENUMERAL: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebinary__ieee_2ENaN,type,
    c_2Ebinary__ieee_2ENaN: tyop_2Ebinary__ieee_2Efloat__value ).

thf(c_2Einteger_2ENum,type,
    c_2Einteger_2ENum: tyop_2Einteger_2Eint > tyop_2Enum_2Enum ).

thf(c_2Eoption_2ESOME,type,
    c_2Eoption_2ESOME: 
      !>[A_27a: $tType] : ( A_27a > ( tyop_2Eoption_2Eoption @ A_27a ) ) ).

thf(c_2Enum_2ESUC,type,
    c_2Enum_2ESUC: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebool_2ET,type,
    c_2Ebool_2ET: $o ).

thf(c_2Ebool_2ETYPE__DEFINITION,type,
    c_2Ebool_2ETYPE__DEFINITION: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > $o ) > ( A_27b > A_27a ) > $o ) ).

thf(c_2Ewords_2EUINT__MAX,type,
    c_2Ewords_2EUINT__MAX: 
      !>[A_27a: $tType] : ( ( tyop_2Ebool_2Eitself @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ebinary__ieee_2EULP,type,
    c_2Ebinary__ieee_2EULP: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) ) > tyop_2Erealax_2Ereal ) ).

thf(c_2Ebinary__ieee_2EUN,type,
    c_2Ebinary__ieee_2EUN: tyop_2Ebinary__ieee_2Efloat__compare ).

thf(c_2Erelation_2EWF,type,
    c_2Erelation_2EWF: 
      !>[A_27a: $tType] : ( ( A_27a > A_27a > $o ) > $o ) ).

thf(c_2Erelation_2EWFREC,type,
    c_2Erelation_2EWFREC: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > A_27a > $o ) > ( ( A_27a > A_27b ) > A_27a > A_27b ) > A_27a > A_27b ) ).

thf(c_2Earithmetic_2EZERO,type,
    c_2Earithmetic_2EZERO: tyop_2Enum_2Enum ).

thf(c_2Ebool_2E_5C_2F,type,
    c_2Ebool_2E_5C_2F: $o > $o > $o ).

thf(c_2Ereal_2Eabs,type,
    c_2Ereal_2Eabs: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2EbasicSize_2Ebool__size,type,
    c_2EbasicSize_2Ebool__size: $o > tyop_2Enum_2Enum ).

thf(c_2Ebinary__ieee_2Echeck__for__signalling,type,
    c_2Ebinary__ieee_2Echeck__for__signalling: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Elist_2Elist @ ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) > tyop_2Ebinary__ieee_2Eflags ) ).

thf(c_2Ebinary__ieee_2Eclear__flags,type,
    c_2Ebinary__ieee_2Eclear__flags: tyop_2Ebinary__ieee_2Eflags ).

thf(c_2Ebinary__ieee_2Eclosest,type,
    c_2Ebinary__ieee_2Eclosest: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) > $o ) > tyop_2Erealax_2Ereal > ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) ).

thf(c_2Ebinary__ieee_2Eclosest__such,type,
    c_2Ebinary__ieee_2Eclosest__such: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) > $o ) > ( ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) > $o ) > tyop_2Erealax_2Ereal > ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) ).

thf(c_2Efcp_2Edimindex,type,
    c_2Efcp_2Edimindex: 
      !>[A_27a: $tType] : ( ( tyop_2Ebool_2Eitself @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ebinary__ieee_2Edividezero__flags,type,
    c_2Ebinary__ieee_2Edividezero__flags: tyop_2Ebinary__ieee_2Eflags ).

thf(c_2Ebinary__ieee_2Eexponent__boundary,type,
    c_2Ebinary__ieee_2Eexponent__boundary: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Eflags__CASE,type,
    c_2Ebinary__ieee_2Eflags__CASE: 
      !>[A_27a: $tType] : ( tyop_2Ebinary__ieee_2Eflags > ( $o > $o > $o > $o > $o > $o > A_27a ) > A_27a ) ).

thf(c_2Ebinary__ieee_2Eflags__DivideByZero,type,
    c_2Ebinary__ieee_2Eflags__DivideByZero: tyop_2Ebinary__ieee_2Eflags > $o ).

thf(c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,type,
    c_2Ebinary__ieee_2Eflags__DivideByZero__fupd: ( $o > $o ) > tyop_2Ebinary__ieee_2Eflags > tyop_2Ebinary__ieee_2Eflags ).

thf(c_2Ebinary__ieee_2Eflags__InvalidOp,type,
    c_2Ebinary__ieee_2Eflags__InvalidOp: tyop_2Ebinary__ieee_2Eflags > $o ).

thf(c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,type,
    c_2Ebinary__ieee_2Eflags__InvalidOp__fupd: ( $o > $o ) > tyop_2Ebinary__ieee_2Eflags > tyop_2Ebinary__ieee_2Eflags ).

thf(c_2Ebinary__ieee_2Eflags__Overflow,type,
    c_2Ebinary__ieee_2Eflags__Overflow: tyop_2Ebinary__ieee_2Eflags > $o ).

thf(c_2Ebinary__ieee_2Eflags__Overflow__fupd,type,
    c_2Ebinary__ieee_2Eflags__Overflow__fupd: ( $o > $o ) > tyop_2Ebinary__ieee_2Eflags > tyop_2Ebinary__ieee_2Eflags ).

thf(c_2Ebinary__ieee_2Eflags__Precision,type,
    c_2Ebinary__ieee_2Eflags__Precision: tyop_2Ebinary__ieee_2Eflags > $o ).

thf(c_2Ebinary__ieee_2Eflags__Precision__fupd,type,
    c_2Ebinary__ieee_2Eflags__Precision__fupd: ( $o > $o ) > tyop_2Ebinary__ieee_2Eflags > tyop_2Ebinary__ieee_2Eflags ).

thf(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,type,
    c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding: tyop_2Ebinary__ieee_2Eflags > $o ).

thf(c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,type,
    c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd: ( $o > $o ) > tyop_2Ebinary__ieee_2Eflags > tyop_2Ebinary__ieee_2Eflags ).

thf(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,type,
    c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding: tyop_2Ebinary__ieee_2Eflags > $o ).

thf(c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,type,
    c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd: ( $o > $o ) > tyop_2Ebinary__ieee_2Eflags > tyop_2Ebinary__ieee_2Eflags ).

thf(c_2Ebinary__ieee_2Eflags__size,type,
    c_2Ebinary__ieee_2Eflags__size: tyop_2Ebinary__ieee_2Eflags > tyop_2Enum_2Enum ).

thf(c_2Ebinary__ieee_2Efloat__CASE,type,
    c_2Ebinary__ieee_2Efloat__CASE: 
      !>[A_27a: $tType,A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > A_27a ) > A_27a ) ).

thf(c_2Ebinary__ieee_2Efloat__Exponent,type,
    c_2Ebinary__ieee_2Efloat__Exponent: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__Exponent__fupd,type,
    c_2Ebinary__ieee_2Efloat__Exponent__fupd: 
      !>[A_27t: $tType,A_27w: $tType,A_27x: $tType] : ( ( ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) ) ).

thf(c_2Ebinary__ieee_2Efloat__Sign,type,
    c_2Ebinary__ieee_2Efloat__Sign: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) ).

thf(c_2Ebinary__ieee_2Efloat__Sign__fupd,type,
    c_2Ebinary__ieee_2Efloat__Sign__fupd: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__Significand,type,
    c_2Ebinary__ieee_2Efloat__Significand: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) ).

thf(c_2Ebinary__ieee_2Efloat__Significand__fupd,type,
    c_2Ebinary__ieee_2Efloat__Significand__fupd: 
      !>[A_27t: $tType,A_27u: $tType,A_27w: $tType] : ( ( ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__abs,type,
    c_2Ebinary__ieee_2Efloat__abs: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__add,type,
    c_2Ebinary__ieee_2Efloat__add: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(c_2Ebinary__ieee_2Efloat__bottom,type,
    c_2Ebinary__ieee_2Efloat__bottom: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__compare,type,
    c_2Ebinary__ieee_2Efloat__compare: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > tyop_2Ebinary__ieee_2Efloat__compare ) ).

thf(c_2Ebinary__ieee_2Efloat__compare2num,type,
    c_2Ebinary__ieee_2Efloat__compare2num: tyop_2Ebinary__ieee_2Efloat__compare > tyop_2Enum_2Enum ).

thf(c_2Ebinary__ieee_2Efloat__compare__CASE,type,
    c_2Ebinary__ieee_2Efloat__compare__CASE: 
      !>[A_27a: $tType] : ( tyop_2Ebinary__ieee_2Efloat__compare > A_27a > A_27a > A_27a > A_27a > A_27a ) ).

thf(c_2Ebinary__ieee_2Efloat__compare__size,type,
    c_2Ebinary__ieee_2Efloat__compare__size: tyop_2Ebinary__ieee_2Efloat__compare > tyop_2Enum_2Enum ).

thf(c_2Ebinary__ieee_2Efloat__div,type,
    c_2Ebinary__ieee_2Efloat__div: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(c_2Ebinary__ieee_2Efloat__equal,type,
    c_2Ebinary__ieee_2Efloat__equal: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__greater__equal,type,
    c_2Ebinary__ieee_2Efloat__greater__equal: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__greater__than,type,
    c_2Ebinary__ieee_2Efloat__greater__than: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__is__finite,type,
    c_2Ebinary__ieee_2Efloat__is__finite: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__is__infinite,type,
    c_2Ebinary__ieee_2Efloat__is__infinite: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__is__integral,type,
    c_2Ebinary__ieee_2Efloat__is__integral: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__is__nan,type,
    c_2Ebinary__ieee_2Efloat__is__nan: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__is__normal,type,
    c_2Ebinary__ieee_2Efloat__is__normal: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__is__signalling,type,
    c_2Ebinary__ieee_2Efloat__is__signalling: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__is__subnormal,type,
    c_2Ebinary__ieee_2Efloat__is__subnormal: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__is__zero,type,
    c_2Ebinary__ieee_2Efloat__is__zero: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__less__equal,type,
    c_2Ebinary__ieee_2Efloat__less__equal: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__less__than,type,
    c_2Ebinary__ieee_2Efloat__less__than: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o ) ).

thf(c_2Ebinary__ieee_2Efloat__minus__infinity,type,
    c_2Ebinary__ieee_2Efloat__minus__infinity: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__minus__min,type,
    c_2Ebinary__ieee_2Efloat__minus__min: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__minus__zero,type,
    c_2Ebinary__ieee_2Efloat__minus__zero: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__mul,type,
    c_2Ebinary__ieee_2Efloat__mul: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(c_2Ebinary__ieee_2Efloat__mul__add,type,
    c_2Ebinary__ieee_2Efloat__mul__add: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(c_2Ebinary__ieee_2Efloat__mul__sub,type,
    c_2Ebinary__ieee_2Efloat__mul__sub: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(c_2Ebinary__ieee_2Efloat__negate,type,
    c_2Ebinary__ieee_2Efloat__negate: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__plus__infinity,type,
    c_2Ebinary__ieee_2Efloat__plus__infinity: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__plus__min,type,
    c_2Ebinary__ieee_2Efloat__plus__min: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__plus__zero,type,
    c_2Ebinary__ieee_2Efloat__plus__zero: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__round,type,
    c_2Ebinary__ieee_2Efloat__round: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > $o > tyop_2Erealax_2Ereal > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__round__to__integral,type,
    c_2Ebinary__ieee_2Efloat__round__to__integral: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__round__with__flags,type,
    c_2Ebinary__ieee_2Efloat__round__with__flags: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > $o > tyop_2Erealax_2Ereal > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(c_2Ebinary__ieee_2Efloat__size,type,
    c_2Ebinary__ieee_2Efloat__size: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( A_27t > tyop_2Enum_2Enum ) > ( A_27w > tyop_2Enum_2Enum ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > tyop_2Enum_2Enum ) ).

thf(c_2Ebinary__ieee_2Efloat__some__qnan,type,
    c_2Ebinary__ieee_2Efloat__some__qnan: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__sqrt,type,
    c_2Ebinary__ieee_2Efloat__sqrt: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(c_2Ebinary__ieee_2Efloat__sub,type,
    c_2Ebinary__ieee_2Efloat__sub: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(c_2Ebinary__ieee_2Efloat__to__int,type,
    c_2Ebinary__ieee_2Efloat__to__int: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Eoption_2Eoption @ tyop_2Einteger_2Eint ) ) ).

thf(c_2Ebinary__ieee_2Efloat__to__real,type,
    c_2Ebinary__ieee_2Efloat__to__real: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > tyop_2Erealax_2Ereal ) ).

thf(c_2Ebinary__ieee_2Efloat__top,type,
    c_2Ebinary__ieee_2Efloat__top: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Efloat__value,type,
    c_2Ebinary__ieee_2Efloat__value: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > tyop_2Ebinary__ieee_2Efloat__value ) ).

thf(c_2Ebinary__ieee_2Efloat__value__CASE,type,
    c_2Ebinary__ieee_2Efloat__value__CASE: 
      !>[A_27a: $tType] : ( tyop_2Ebinary__ieee_2Efloat__value > ( tyop_2Erealax_2Ereal > A_27a ) > A_27a > A_27a > A_27a ) ).

thf(c_2Ebinary__ieee_2Efloat__value__size,type,
    c_2Ebinary__ieee_2Efloat__value__size: tyop_2Ebinary__ieee_2Efloat__value > tyop_2Enum_2Enum ).

thf(c_2Ebinary__ieee_2Efp__op__CASE,type,
    c_2Ebinary__ieee_2Efp__op__CASE: 
      !>[A_27a: $tType,A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a ) > A_27a ) ).

thf(c_2Ebinary__ieee_2Efp__op__size,type,
    c_2Ebinary__ieee_2Efp__op__size: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( A_27t > tyop_2Enum_2Enum ) > ( A_27w > tyop_2Enum_2Enum ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) > tyop_2Enum_2Enum ) ).

thf(c_2Ebinary__ieee_2Eintegral__round,type,
    c_2Ebinary__ieee_2Eintegral__round: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > tyop_2Erealax_2Ereal > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Erealax_2Einv,type,
    c_2Erealax_2Einv: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Ebinary__ieee_2Einvalidop__flags,type,
    c_2Ebinary__ieee_2Einvalidop__flags: tyop_2Ebinary__ieee_2Eflags ).

thf(c_2Ebinary__ieee_2Eis__closest,type,
    c_2Ebinary__ieee_2Eis__closest: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) > $o ) > tyop_2Erealax_2Ereal > ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) > $o ) ).

thf(c_2Ebinary__ieee_2Eis__integral,type,
    c_2Ebinary__ieee_2Eis__integral: tyop_2Erealax_2Ereal > $o ).

thf(c_2Ebinary__ieee_2Elargest,type,
    c_2Ebinary__ieee_2Elargest: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > tyop_2Erealax_2Ereal ) ).

thf(c_2Ewords_2En2w,type,
    c_2Ewords_2En2w: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ebinary__ieee_2Enum2float__compare,type,
    c_2Ebinary__ieee_2Enum2float__compare: tyop_2Enum_2Enum > tyop_2Ebinary__ieee_2Efloat__compare ).

thf(c_2Ebinary__ieee_2Enum2rounding,type,
    c_2Ebinary__ieee_2Enum2rounding: tyop_2Enum_2Enum > tyop_2Ebinary__ieee_2Erounding ).

thf(c_2Ecombin_2Eo,type,
    c_2Ecombin_2Eo: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( A_27c > A_27b ) > ( A_27a > A_27c ) > A_27a > A_27b ) ).

thf(c_2Epair_2Epair__CASE,type,
    c_2Epair_2Epair__CASE: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( tyop_2Epair_2Eprod @ A_27b @ A_27c ) > ( A_27b > A_27c > A_27a ) > A_27a ) ).

thf(c_2Ereal_2Epow,type,
    c_2Ereal_2Epow: tyop_2Erealax_2Ereal > tyop_2Enum_2Enum > tyop_2Erealax_2Ereal ).

thf(c_2Erealax_2Ereal__add,type,
    c_2Erealax_2Ereal__add: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Ereal_2Ereal__ge,type,
    c_2Ereal_2Ereal__ge: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > $o ).

thf(c_2Ereal_2Ereal__gt,type,
    c_2Ereal_2Ereal__gt: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > $o ).

thf(c_2Erealax_2Ereal__lt,type,
    c_2Erealax_2Ereal__lt: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > $o ).

thf(c_2Ereal_2Ereal__lte,type,
    c_2Ereal_2Ereal__lte: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > $o ).

thf(c_2Erealax_2Ereal__mul,type,
    c_2Erealax_2Ereal__mul: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Erealax_2Ereal__neg,type,
    c_2Erealax_2Ereal__neg: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Eintreal_2Ereal__of__int,type,
    c_2Eintreal_2Ereal__of__int: tyop_2Einteger_2Eint > tyop_2Erealax_2Ereal ).

thf(c_2Ereal_2Ereal__of__num,type,
    c_2Ereal_2Ereal__of__num: tyop_2Enum_2Enum > tyop_2Erealax_2Ereal ).

thf(c_2Ereal_2Ereal__sub,type,
    c_2Ereal_2Ereal__sub: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Ebinary__ieee_2Ereal__to__float,type,
    c_2Ebinary__ieee_2Ereal__to__float: 
      !>[A_27a: $tType,A_27b: $tType] : ( tyop_2Ebinary__ieee_2Erounding > tyop_2Erealax_2Ereal > ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) ).

thf(c_2Ebinary__ieee_2Ereal__to__float__with__flags,type,
    c_2Ebinary__ieee_2Ereal__to__float__with__flags: 
      !>[A_27a: $tType,A_27b: $tType] : ( tyop_2Ebinary__ieee_2Erounding > tyop_2Erealax_2Ereal > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) ) ).

thf(c_2Ebinary__ieee_2Erecordtype_2Eflags,type,
    c_2Ebinary__ieee_2Erecordtype_2Eflags: $o > $o > $o > $o > $o > $o > tyop_2Ebinary__ieee_2Eflags ).

thf(c_2Ebinary__ieee_2Erecordtype_2Efloat,type,
    c_2Ebinary__ieee_2Erecordtype_2Efloat: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2Eround,type,
    c_2Ebinary__ieee_2Eround: 
      !>[A_27t: $tType,A_27w: $tType] : ( tyop_2Ebinary__ieee_2Erounding > tyop_2Erealax_2Ereal > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ).

thf(c_2Ebinary__ieee_2EroundTiesToEven,type,
    c_2Ebinary__ieee_2EroundTiesToEven: tyop_2Ebinary__ieee_2Erounding ).

thf(c_2Ebinary__ieee_2EroundTowardNegative,type,
    c_2Ebinary__ieee_2EroundTowardNegative: tyop_2Ebinary__ieee_2Erounding ).

thf(c_2Ebinary__ieee_2EroundTowardPositive,type,
    c_2Ebinary__ieee_2EroundTowardPositive: tyop_2Ebinary__ieee_2Erounding ).

thf(c_2Ebinary__ieee_2EroundTowardZero,type,
    c_2Ebinary__ieee_2EroundTowardZero: tyop_2Ebinary__ieee_2Erounding ).

thf(c_2Ebinary__ieee_2Erounding2num,type,
    c_2Ebinary__ieee_2Erounding2num: tyop_2Ebinary__ieee_2Erounding > tyop_2Enum_2Enum ).

thf(c_2Ebinary__ieee_2Erounding__CASE,type,
    c_2Ebinary__ieee_2Erounding__CASE: 
      !>[A_27a: $tType] : ( tyop_2Ebinary__ieee_2Erounding > A_27a > A_27a > A_27a > A_27a > A_27a ) ).

thf(c_2Ebinary__ieee_2Erounding__size,type,
    c_2Ebinary__ieee_2Erounding__size: tyop_2Ebinary__ieee_2Erounding > tyop_2Enum_2Enum ).

thf(c_2Etransc_2Esqrt,type,
    c_2Etransc_2Esqrt: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Ebool_2Ethe__value,type,
    c_2Ebool_2Ethe__value: 
      !>[A_27a: $tType] : ( tyop_2Ebool_2Eitself @ A_27a ) ).

thf(c_2Ebinary__ieee_2Ethreshold,type,
    c_2Ebinary__ieee_2Ethreshold: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > tyop_2Erealax_2Ereal ) ).

thf(c_2Ebinary__ieee_2Eulp,type,
    c_2Ebinary__ieee_2Eulp: 
      !>[A_27t: $tType,A_27w: $tType] : ( ( tyop_2Ebool_2Eitself @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) > tyop_2Erealax_2Ereal ) ).

thf(c_2Ewords_2Ew2n,type,
    c_2Ewords_2Ew2n: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > tyop_2Enum_2Enum ) ).

thf(c_2Ewords_2Eword__1comp,type,
    c_2Ewords_2Eword__1comp: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__2comp,type,
    c_2Ewords_2Eword__2comp: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__T,type,
    c_2Ewords_2Eword__T: 
      !>[A_27a: $tType] : ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ).

thf(c_2Ewords_2Eword__ls,type,
    c_2Ewords_2Eword__ls: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__lsb,type,
    c_2Ewords_2Eword__lsb: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__msb,type,
    c_2Ewords_2Eword__msb: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > $o ) ).

thf(c_2Ewords_2Eword__sub,type,
    c_2Ewords_2Eword__sub: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ewords_2Eword__xor,type,
    c_2Ewords_2Eword__xor: 
      !>[A_27a: $tType] : ( ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) > ( tyop_2Efcp_2Ecart @ $o @ A_27a ) ) ).

thf(c_2Ebool_2E_7E,type,
    c_2Ebool_2E_7E: $o > $o ).

thf(logicdef_2E_2F_5C,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Ebool_2E_2F_5C @ V0 @ V1 )
    <=> ( V0
        & V1 ) ) ).

thf(logicdef_2E_5C_2F,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Ebool_2E_5C_2F @ V0 @ V1 )
    <=> ( V0
        | V1 ) ) ).

thf(logicdef_2E_7E,axiom,
    ! [V0: $o] :
      ( ( c_2Ebool_2E_7E @ V0 )
    <=> ( (~) @ V0 ) ) ).

thf(logicdef_2E_3D_3D_3E,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Emin_2E_3D_3D_3E @ V0 @ V1 )
    <=> ( V0
       => V1 ) ) ).

thf(logicdef_2E_3D,axiom,
    ! [A_27a: $tType,V0: A_27a,V1: A_27a] :
      ( ( c_2Emin_2E_3D @ A_27a @ V0 @ V1 )
    <=> ( V0 = V1 ) ) ).

thf(quantdef_2E_21,axiom,
    ! [A_27a: $tType,V0f: A_27a > $o] :
      ( ( c_2Ebool_2E_21 @ A_27a @ V0f )
    <=> ! [V1x: A_27a] : ( V0f @ V1x ) ) ).

thf(quantdef_2E_3F,axiom,
    ! [A_27a: $tType,V0f: A_27a > $o] :
      ( ( c_2Ebool_2E_3F @ A_27a @ V0f )
    <=> ? [V1x: A_27a] : ( V0f @ V1x ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__TY__DEF,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
    ? [V0rep: ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) ) )] :
      ( c_2Ebool_2ETYPE__DEFINITION @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) ) ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
      @ ^ [V1a0_27: tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) )] :
          ( c_2Ebool_2E_21 @ ( ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) ) ) > $o )
          @ ^ [V2_27float_27: ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) ) ) > $o] :
              ( c_2Emin_2E_3D_3D_3E
              @ ( c_2Ebool_2E_21 @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) ) )
                @ ^ [V3a0_27: tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) )] :
                    ( c_2Emin_2E_3D_3D_3E
                    @ ( c_2Ebool_2E_3F @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )
                      @ ^ [V4a0: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone] :
                          ( c_2Ebool_2E_3F @ ( tyop_2Efcp_2Ecart @ $o @ A_27w )
                          @ ^ [V5a1: tyop_2Efcp_2Ecart @ $o @ A_27w] :
                              ( c_2Ebool_2E_3F @ ( tyop_2Efcp_2Ecart @ $o @ A_27t )
                              @ ^ [V6a2: tyop_2Efcp_2Ecart @ $o @ A_27t] :
                                  ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) ) ) @ V3a0_27
                                  @ ( ^ [V7a0: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V8a1: tyop_2Efcp_2Ecart @ $o @ A_27w,V9a2: tyop_2Efcp_2Ecart @ $o @ A_27t] :
                                        ( c_2Eind__type_2ECONSTR @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) ) @ c_2Enum_2E0 @ ( c_2Epair_2E_2C @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) @ V7a0 @ ( c_2Epair_2E_2C @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ V8a1 @ V9a2 ) )
                                        @ ^ [V10n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) ) ) ) )
                                    @ V4a0
                                    @ V5a1
                                    @ V6a2 ) ) ) ) )
                    @ ( V2_27float_27 @ V3a0_27 ) ) )
              @ ( V2_27float_27 @ V1a0_27 ) ) )
      @ V0rep ) ).

thf(thm_2Ebinary__ieee_2Efloat__case__def,axiom,
    ! [A_27a: $tType,A_27t: $tType,A_27w: $tType,V0a0: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V1a1: tyop_2Efcp_2Ecart @ $o @ A_27w,V2a2: tyop_2Efcp_2Ecart @ $o @ A_27t,V3f: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > A_27a] :
      ( ( c_2Ebinary__ieee_2Efloat__CASE @ A_27a @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V0a0 @ V1a1 @ V2a2 ) @ V3f )
      = ( V3f @ V0a0 @ V1a1 @ V2a2 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__size__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0f: A_27t > tyop_2Enum_2Enum,V1f1: A_27w > tyop_2Enum_2Enum,V2a0: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V3a1: tyop_2Efcp_2Ecart @ $o @ A_27w,V4a2: tyop_2Efcp_2Ecart @ $o @ A_27t] :
      ( ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V0f @ V1f1 @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V2a0 @ V3a1 @ V4a2 ) )
      = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__Sign,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V1c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V2c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
      ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V0c @ V1c0 @ V2c1 ) )
      = V0c ) ).

thf(thm_2Ebinary__ieee_2Efloat__Exponent,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V1c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V2c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
      ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V0c @ V1c0 @ V2c1 ) )
      = V1c0 ) ).

thf(thm_2Ebinary__ieee_2Efloat__Significand,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V1c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V2c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
      ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V0c @ V1c0 @ V2c1 ) )
      = V2c1 ) ).

thf(thm_2Ebinary__ieee_2Efloat__Sign__fupd,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0f: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V1c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V2c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V3c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
      ( ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V1c @ V2c0 @ V3c1 ) )
      = ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ ( V0f @ V1c ) @ V2c0 @ V3c1 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__Exponent__fupd,axiom,
    ! [A_27t: $tType,A_27w: $tType,A_27x: $tType,V0f: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V1c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V2c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V3c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
      ( ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V1c @ V2c0 @ V3c1 ) )
      = ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27x @ V1c @ ( V0f @ V2c0 ) @ V3c1 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__Significand__fupd,axiom,
    ! [A_27t: $tType,A_27u: $tType,A_27w: $tType,V0f: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ),V1c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V2c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V3c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
      ( ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V1c @ V2c0 @ V3c1 ) )
      = ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27u @ A_27w @ V1c @ V2c0 @ ( V0f @ V3c1 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__TY__DEF,axiom,
    ? [V0rep: tyop_2Ebinary__ieee_2Efloat__value > ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal )] :
      ( c_2Ebool_2ETYPE__DEFINITION @ ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) @ tyop_2Ebinary__ieee_2Efloat__value
      @ ^ [V1a0: tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal] :
          ( c_2Ebool_2E_21 @ ( ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) > $o )
          @ ^ [V2_27float__value_27: ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) > $o] :
              ( c_2Emin_2E_3D_3D_3E
              @ ( c_2Ebool_2E_21 @ ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal )
                @ ^ [V3a0: tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal] :
                    ( c_2Emin_2E_3D_3D_3E
                    @ ( c_2Ebool_2E_5C_2F
                      @ ( c_2Ebool_2E_3F @ tyop_2Erealax_2Ereal
                        @ ^ [V4a: tyop_2Erealax_2Ereal] :
                            ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) @ V3a0
                            @ ( ^ [V5a: tyop_2Erealax_2Ereal] :
                                  ( c_2Eind__type_2ECONSTR @ tyop_2Erealax_2Ereal @ c_2Enum_2E0 @ V5a
                                  @ ^ [V6n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ tyop_2Erealax_2Ereal ) )
                              @ V4a ) ) )
                      @ ( c_2Ebool_2E_5C_2F
                        @ ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) @ V3a0
                          @ ( c_2Eind__type_2ECONSTR @ tyop_2Erealax_2Ereal @ ( c_2Enum_2ESUC @ c_2Enum_2E0 ) @ ( c_2Ebool_2EARB @ tyop_2Erealax_2Ereal )
                            @ ^ [V7n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ tyop_2Erealax_2Ereal ) ) )
                        @ ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) @ V3a0
                          @ ( c_2Eind__type_2ECONSTR @ tyop_2Erealax_2Ereal @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2EARB @ tyop_2Erealax_2Ereal )
                            @ ^ [V8n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ tyop_2Erealax_2Ereal ) ) ) ) )
                    @ ( V2_27float__value_27 @ V3a0 ) ) )
              @ ( V2_27float__value_27 @ V1a0 ) ) )
      @ V0rep ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__case__def,axiom,
    ! [A_27a: $tType] :
      ( ! [V0a: tyop_2Erealax_2Ereal,V1f: tyop_2Erealax_2Ereal > A_27a,V2v: A_27a,V3v1: A_27a] :
          ( ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a @ ( c_2Ebinary__ieee_2EFloat @ V0a ) @ V1f @ V2v @ V3v1 )
          = ( V1f @ V0a ) )
      & ! [V4f: tyop_2Erealax_2Ereal > A_27a,V5v: A_27a,V6v1: A_27a] :
          ( ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a @ c_2Ebinary__ieee_2EInfinity @ V4f @ V5v @ V6v1 )
          = V5v )
      & ! [V7f: tyop_2Erealax_2Ereal > A_27a,V8v: A_27a,V9v1: A_27a] :
          ( ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a @ c_2Ebinary__ieee_2ENaN @ V7f @ V8v @ V9v1 )
          = V9v1 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__size__def,axiom,
    ( ! [V0a: tyop_2Erealax_2Ereal] :
        ( ( c_2Ebinary__ieee_2Efloat__value__size @ ( c_2Ebinary__ieee_2EFloat @ V0a ) )
        = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
    & ( ( c_2Ebinary__ieee_2Efloat__value__size @ c_2Ebinary__ieee_2EInfinity )
      = c_2Enum_2E0 )
    & ( ( c_2Ebinary__ieee_2Efloat__value__size @ c_2Ebinary__ieee_2ENaN )
      = c_2Enum_2E0 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__to__real__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V0x )
      = ( c_2Ebool_2ECOND @ tyop_2Erealax_2Ereal @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V0x ) @ ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) ) @ ( c_2Erealax_2Ereal__mul @ ( c_2Erealax_2Ereal__mul @ ( c_2Ereal_2Epow @ ( c_2Erealax_2Ereal__neg @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Ewords_2Ew2n @ tyop_2Eone_2Eone @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V0x ) ) ) @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ewords_2EINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) ) @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Ereal__of__num @ ( c_2Ewords_2Ew2n @ A_27t @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V0x ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Efcp_2Edimindex @ A_27t @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) @ ( c_2Erealax_2Ereal__mul @ ( c_2Erealax_2Ereal__mul @ ( c_2Ereal_2Epow @ ( c_2Erealax_2Ereal__neg @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Ewords_2Ew2n @ tyop_2Eone_2Eone @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V0x ) ) ) @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ewords_2Ew2n @ A_27w @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V0x ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ewords_2EINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) ) @ ( c_2Erealax_2Ereal__add @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Ereal__of__num @ ( c_2Ewords_2Ew2n @ A_27t @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V0x ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Efcp_2Edimindex @ A_27t @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V0x )
      = ( c_2Ebool_2ECOND @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V0x ) @ ( c_2Ewords_2Eword__T @ A_27w ) ) @ ( c_2Ebool_2ECOND @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V0x ) @ ( c_2Ewords_2En2w @ A_27t @ c_2Enum_2E0 ) ) @ c_2Ebinary__ieee_2EInfinity @ c_2Ebinary__ieee_2ENaN ) @ ( c_2Ebinary__ieee_2EFloat @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V0x ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__nan__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ V0x )
      = ( c_2Ebinary__ieee_2Efloat__value__CASE @ $o @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V0x )
        @ ^ [V1v1: tyop_2Erealax_2Ereal] : c_2Ebool_2EF
        @ c_2Ebool_2EF
        @ c_2Ebool_2ET ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__signalling__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__is__signalling @ A_27t @ A_27w @ V0x )
    <=> ( ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ V0x )
        & ( (~) @ ( c_2Ewords_2Eword__msb @ A_27t @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V0x ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__infinite__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V0x )
      = ( c_2Ebinary__ieee_2Efloat__value__CASE @ $o @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V0x )
        @ ^ [V1v1: tyop_2Erealax_2Ereal] : c_2Ebool_2EF
        @ c_2Ebool_2ET
        @ c_2Ebool_2EF ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__normal__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w @ V0x )
    <=> ( ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V0x )
            = ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) ) )
        & ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V0x )
            = ( c_2Ewords_2Eword__T @ A_27w ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__subnormal__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w @ V0x )
    <=> ( ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V0x )
          = ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) )
        & ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V0x )
            = ( c_2Ewords_2En2w @ A_27t @ c_2Enum_2E0 ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__zero__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ V0x )
      = ( c_2Ebinary__ieee_2Efloat__value__CASE @ $o @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V0x )
        @ ^ [V1r: tyop_2Erealax_2Ereal] : ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V1r @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
        @ c_2Ebool_2EF
        @ c_2Ebool_2EF ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__finite__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ V0x )
      = ( c_2Ebinary__ieee_2Efloat__value__CASE @ $o @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V0x )
        @ ^ [V1v1: tyop_2Erealax_2Ereal] : c_2Ebool_2ET
        @ c_2Ebool_2EF
        @ c_2Ebool_2EF ) ) ).

thf(thm_2Ebinary__ieee_2Eis__integral__def,axiom,
    ! [V0r: tyop_2Erealax_2Ereal] :
      ( ( c_2Ebinary__ieee_2Eis__integral @ V0r )
    <=> ? [V1n: tyop_2Enum_2Enum] :
          ( ( c_2Ereal_2Eabs @ V0r )
          = ( c_2Ereal_2Ereal__of__num @ V1n ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__integral__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w @ V0x )
      = ( c_2Ebinary__ieee_2Efloat__value__CASE @ $o @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V0x )
        @ ^ [V1r: tyop_2Erealax_2Ereal] : ( c_2Ebinary__ieee_2Eis__integral @ V1r )
        @ c_2Ebool_2EF
        @ c_2Ebool_2EF ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__negate__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w @ V0x )
      = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2Eword__1comp @ tyop_2Eone_2Eone @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V0x ) ) ) @ V0x ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__abs__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__abs @ A_27t @ A_27w @ V0x )
      = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) @ V0x ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__plus__infinity__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( c_2Ewords_2Eword__T @ A_27w ) ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27t @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( c_2Ewords_2En2w @ A_27t @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__plus__zero__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27t @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( c_2Ewords_2En2w @ A_27t @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__top__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( c_2Ewords_2Eword__sub @ A_27w @ ( c_2Ewords_2Eword__T @ A_27w ) @ ( c_2Ewords_2En2w @ A_27w @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27t @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( c_2Ewords_2Eword__T @ A_27t ) ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__plus__min__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27t @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( c_2Ewords_2En2w @ A_27t @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__minus__infinity__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__minus__zero__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__bottom__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__minus__min__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__TY__DEF,axiom,
    ? [V0rep: tyop_2Ebinary__ieee_2Eflags > ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) ) )] :
      ( c_2Ebool_2ETYPE__DEFINITION @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) ) ) @ tyop_2Ebinary__ieee_2Eflags
      @ ^ [V1a0_27: tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) )] :
          ( c_2Ebool_2E_21 @ ( ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) ) ) > $o )
          @ ^ [V2_27flags_27: ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) ) ) > $o] :
              ( c_2Emin_2E_3D_3D_3E
              @ ( c_2Ebool_2E_21 @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) ) )
                @ ^ [V3a0_27: tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) )] :
                    ( c_2Emin_2E_3D_3D_3E
                    @ ( c_2Ebool_2E_3F @ $o
                      @ ^ [V4a0: $o] :
                          ( c_2Ebool_2E_3F @ $o
                          @ ^ [V5a1: $o] :
                              ( c_2Ebool_2E_3F @ $o
                              @ ^ [V6a2: $o] :
                                  ( c_2Ebool_2E_3F @ $o
                                  @ ^ [V7a3: $o] :
                                      ( c_2Ebool_2E_3F @ $o
                                      @ ^ [V8a4: $o] :
                                          ( c_2Ebool_2E_3F @ $o
                                          @ ^ [V9a5: $o] :
                                              ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) ) ) @ V3a0_27
                                              @ ( ^ [V10a0: $o,V11a1: $o,V12a2: $o,V13a3: $o,V14a4: $o,V15a5: $o] :
                                                    ( c_2Eind__type_2ECONSTR @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) ) @ c_2Enum_2E0 @ ( c_2Epair_2E_2C @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) @ V10a0 @ ( c_2Epair_2E_2C @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) @ V11a1 @ ( c_2Epair_2E_2C @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) @ V12a2 @ ( c_2Epair_2E_2C @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) @ V13a3 @ ( c_2Epair_2E_2C @ $o @ $o @ V14a4 @ V15a5 ) ) ) ) )
                                                    @ ^ [V16n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ ( tyop_2Epair_2Eprod @ $o @ $o ) ) ) ) ) ) )
                                                @ V4a0
                                                @ V5a1
                                                @ V6a2
                                                @ V7a3
                                                @ V8a4
                                                @ V9a5 ) ) ) ) ) ) ) )
                    @ ( V2_27flags_27 @ V3a0_27 ) ) )
              @ ( V2_27flags_27 @ V1a0_27 ) ) )
      @ V0rep ) ).

thf(thm_2Ebinary__ieee_2Eflags__case__def,axiom,
    ! [A_27a: $tType,V0a0: $o,V1a1: $o,V2a2: $o,V3a3: $o,V4a4: $o,V5a5: $o,V6f: $o > $o > $o > $o > $o > $o > A_27a] :
      ( ( c_2Ebinary__ieee_2Eflags__CASE @ A_27a @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0a0 @ V1a1 @ V2a2 @ V3a3 @ V4a4 @ V5a5 ) @ V6f )
      = ( V6f @ V0a0 @ V1a1 @ V2a2 @ V3a3 @ V4a4 @ V5a5 ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__size__def,axiom,
    ! [V0a0: $o,V1a1: $o,V2a2: $o,V3a3: $o,V4a4: $o,V5a5: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__size @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0a0 @ V1a1 @ V2a2 @ V3a3 @ V4a4 @ V5a5 ) )
      = ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2EbasicSize_2Ebool__size @ V0a0 ) @ ( c_2Earithmetic_2E_2B @ ( c_2EbasicSize_2Ebool__size @ V1a1 ) @ ( c_2Earithmetic_2E_2B @ ( c_2EbasicSize_2Ebool__size @ V2a2 ) @ ( c_2Earithmetic_2E_2B @ ( c_2EbasicSize_2Ebool__size @ V3a3 ) @ ( c_2Earithmetic_2E_2B @ ( c_2EbasicSize_2Ebool__size @ V4a4 ) @ ( c_2EbasicSize_2Ebool__size @ V5a5 ) ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__DivideByZero,axiom,
    ! [V0b: $o,V1b0: $o,V2b1: $o,V3b2: $o,V4b3: $o,V5b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__DivideByZero @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b @ V1b0 @ V2b1 @ V3b2 @ V4b3 @ V5b4 ) )
      = V0b ) ).

thf(thm_2Ebinary__ieee_2Eflags__InvalidOp,axiom,
    ! [V0b: $o,V1b0: $o,V2b1: $o,V3b2: $o,V4b3: $o,V5b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__InvalidOp @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b @ V1b0 @ V2b1 @ V3b2 @ V4b3 @ V5b4 ) )
      = V1b0 ) ).

thf(thm_2Ebinary__ieee_2Eflags__Overflow,axiom,
    ! [V0b: $o,V1b0: $o,V2b1: $o,V3b2: $o,V4b3: $o,V5b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__Overflow @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b @ V1b0 @ V2b1 @ V3b2 @ V4b3 @ V5b4 ) )
      = V2b1 ) ).

thf(thm_2Ebinary__ieee_2Eflags__Precision,axiom,
    ! [V0b: $o,V1b0: $o,V2b1: $o,V3b2: $o,V4b3: $o,V5b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__Precision @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b @ V1b0 @ V2b1 @ V3b2 @ V4b3 @ V5b4 ) )
      = V3b2 ) ).

thf(thm_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,axiom,
    ! [V0b: $o,V1b0: $o,V2b1: $o,V3b2: $o,V4b3: $o,V5b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b @ V1b0 @ V2b1 @ V3b2 @ V4b3 @ V5b4 ) )
      = V4b3 ) ).

thf(thm_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,axiom,
    ! [V0b: $o,V1b0: $o,V2b1: $o,V3b2: $o,V4b3: $o,V5b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b @ V1b0 @ V2b1 @ V3b2 @ V4b3 @ V5b4 ) )
      = V5b4 ) ).

thf(thm_2Ebinary__ieee_2Eflags__DivideByZero__fupd,axiom,
    ! [V0f: $o > $o,V1b: $o,V2b0: $o,V3b1: $o,V4b2: $o,V5b3: $o,V6b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) )
      = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ ( V0f @ V1b ) @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__InvalidOp__fupd,axiom,
    ! [V0f: $o > $o,V1b: $o,V2b0: $o,V3b1: $o,V4b2: $o,V5b3: $o,V6b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) )
      = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ ( V0f @ V2b0 ) @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__Overflow__fupd,axiom,
    ! [V0f: $o > $o,V1b: $o,V2b0: $o,V3b1: $o,V4b2: $o,V5b3: $o,V6b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) )
      = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ ( V0f @ V3b1 ) @ V4b2 @ V5b3 @ V6b4 ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__Precision__fupd,axiom,
    ! [V0f: $o > $o,V1b: $o,V2b0: $o,V3b1: $o,V4b2: $o,V5b3: $o,V6b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) )
      = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ ( V0f @ V4b2 ) @ V5b3 @ V6b4 ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,axiom,
    ! [V0f: $o > $o,V1b: $o,V2b0: $o,V3b1: $o,V4b2: $o,V5b3: $o,V6b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) )
      = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ ( V0f @ V5b3 ) @ V6b4 ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,axiom,
    ! [V0f: $o > $o,V1b: $o,V2b0: $o,V3b1: $o,V4b2: $o,V5b3: $o,V6b4: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) )
      = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ ( V0f @ V6b4 ) ) ) ).

thf(thm_2Ebinary__ieee_2Eclear__flags__def,axiom,
    ( c_2Ebinary__ieee_2Eclear__flags
    = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ c_2Ebool_2EF ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ c_2Ebool_2EF ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ c_2Ebool_2EF ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ c_2Ebool_2EF ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ c_2Ebool_2EF ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ c_2Ebool_2EF ) @ ( c_2Ebool_2EARB @ tyop_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Einvalidop__flags__def,axiom,
    ( c_2Ebinary__ieee_2Einvalidop__flags
    = ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ c_2Ebool_2ET ) @ c_2Ebinary__ieee_2Eclear__flags ) ) ).

thf(thm_2Ebinary__ieee_2Edividezero__flags__def,axiom,
    ( c_2Ebinary__ieee_2Edividezero__flags
    = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ c_2Ebool_2ET ) @ c_2Ebinary__ieee_2Eclear__flags ) ) ).

thf(thm_2Ebinary__ieee_2Erounding__TY__DEF,axiom,
    ? [V0rep: tyop_2Ebinary__ieee_2Erounding > tyop_2Enum_2Enum] :
      ( c_2Ebool_2ETYPE__DEFINITION @ tyop_2Enum_2Enum @ tyop_2Ebinary__ieee_2Erounding
      @ ^ [V1n: tyop_2Enum_2Enum] : ( c_2Eprim__rec_2E_3C @ V1n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      @ V0rep ) ).

thf(thm_2Ebinary__ieee_2Erounding__BIJ,axiom,
    ( ! [V0a: tyop_2Ebinary__ieee_2Erounding] :
        ( ( c_2Ebinary__ieee_2Enum2rounding @ ( c_2Ebinary__ieee_2Erounding2num @ V0a ) )
        = V0a )
    & ! [V1r: tyop_2Enum_2Enum] :
        ( ( ^ [V2n: tyop_2Enum_2Enum] : ( c_2Eprim__rec_2E_3C @ V2n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
          @ V1r )
      <=> ( ( c_2Ebinary__ieee_2Erounding2num @ ( c_2Ebinary__ieee_2Enum2rounding @ V1r ) )
          = V1r ) ) ) ).

thf(thm_2Ebinary__ieee_2Erounding__size__def,axiom,
    ! [V0x: tyop_2Ebinary__ieee_2Erounding] :
      ( ( c_2Ebinary__ieee_2Erounding__size @ V0x )
      = c_2Enum_2E0 ) ).

thf(thm_2Ebinary__ieee_2Erounding__CASE,axiom,
    ! [A_27a: $tType,V0x: tyop_2Ebinary__ieee_2Erounding,V1v0: A_27a,V2v1: A_27a,V3v2: A_27a,V4v3: A_27a] :
      ( ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a @ V0x @ V1v0 @ V2v1 @ V3v2 @ V4v3 )
      = ( ^ [V5m: tyop_2Enum_2Enum] : ( c_2Ebool_2ECOND @ A_27a @ ( c_2Eprim__rec_2E_3C @ V5m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V1v0 @ ( c_2Ebool_2ECOND @ A_27a @ ( c_2Eprim__rec_2E_3C @ V5m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V2v1 @ ( c_2Ebool_2ECOND @ A_27a @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ V5m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V3v2 @ V4v3 ) ) )
        @ ( c_2Ebinary__ieee_2Erounding2num @ V0x ) ) ) ).

thf(thm_2Ebinary__ieee_2Eis__closest__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0s: ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) > $o,V1x: tyop_2Erealax_2Ereal,V2a: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
      ( ( c_2Ebinary__ieee_2Eis__closest @ A_27a @ A_27b @ V0s @ V1x @ V2a )
    <=> ( ( c_2Ebool_2EIN @ ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ V2a @ V0s )
        & ! [V3b: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
            ( ( c_2Ebool_2EIN @ ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ V3b @ V0s )
           => ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Eabs @ ( c_2Ereal_2Ereal__sub @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27a @ A_27b @ V2a ) @ V1x ) ) @ ( c_2Ereal_2Eabs @ ( c_2Ereal_2Ereal__sub @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27a @ A_27b @ V3b ) @ V1x ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eclosest__such__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0p: ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) > $o,V1s: ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) > $o,V2x: tyop_2Erealax_2Ereal] :
      ( ( c_2Ebinary__ieee_2Eclosest__such @ A_27a @ A_27b @ V0p @ V1s @ V2x )
      = ( c_2Emin_2E_40 @ ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b )
        @ ^ [V3a: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
            ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Eis__closest @ A_27a @ A_27b @ V1s @ V2x @ V3a )
            @ ( c_2Ebool_2E_21 @ ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b )
              @ ^ [V4b: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] : ( c_2Emin_2E_3D_3D_3E @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Eis__closest @ A_27a @ A_27b @ V1s @ V2x @ V4b ) @ ( V0p @ V4b ) ) @ ( V0p @ V3a ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eclosest__def,axiom,
    ! [A_27a: $tType,A_27b: $tType] :
      ( ( c_2Ebinary__ieee_2Eclosest @ A_27a @ A_27b )
      = ( c_2Ebinary__ieee_2Eclosest__such @ A_27a @ A_27b @ ( c_2Ecombin_2EK @ $o @ ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ c_2Ebool_2ET ) ) ) ).

thf(thm_2Ebinary__ieee_2Elargest__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Erealax_2Ereal__mul @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2E_2D @ ( c_2Ewords_2EUINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ewords_2EINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) @ ( c_2Ereal_2Ereal__sub @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Erealax_2Einv @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Efcp_2Edimindex @ A_27t @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Ethreshold__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Ethreshold @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Erealax_2Ereal__mul @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2E_2D @ ( c_2Ewords_2EUINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ewords_2EINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) @ ( c_2Ereal_2Ereal__sub @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Erealax_2Einv @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Enum_2ESUC @ ( c_2Efcp_2Edimindex @ A_27t @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2EULP__primitive__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2EULP @ A_27t @ A_27w )
      = ( c_2Erelation_2EWFREC @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) ) @ tyop_2Erealax_2Ereal
        @ ( c_2Emin_2E_40 @ ( ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) ) > ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) ) > $o )
          @ ^ [V0R: ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) ) > ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) ) > $o] : ( c_2Erelation_2EWF @ ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) ) @ V0R ) )
        @ ^ [V1ULP: ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) ) > tyop_2Erealax_2Ereal,V2a: tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t )] :
            ( c_2Epair_2Epair__CASE @ tyop_2Erealax_2Ereal @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) @ V2a
            @ ^ [V3v: tyop_2Efcp_2Ecart @ $o @ A_27w,V4v1: tyop_2Ebool_2Eitself @ A_27t] : ( c_2Ecombin_2EI @ tyop_2Erealax_2Ereal @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ebool_2ECOND @ tyop_2Enum_2Enum @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ V3v @ ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Ewords_2Ew2n @ A_27w @ V3v ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ewords_2EINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) @ ( c_2Efcp_2Edimindex @ A_27t @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eulp__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Eulp @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Ebinary__ieee_2EULP @ A_27t @ A_27w @ ( c_2Epair_2E_2C @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) @ ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eround__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Erealax_2Ereal] :
      ( ( c_2Ebinary__ieee_2Eround @ A_27t @ A_27w @ V0mode @ V1x )
      = ( c_2Ebinary__ieee_2Erounding__CASE @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V0mode
        @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
          @ ^ [V2t: tyop_2Erealax_2Ereal] :
              ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ereal_2Ereal__lte @ V1x @ ( c_2Erealax_2Ereal__neg @ V2t ) ) @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
              @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ereal_2Ereal__ge @ V1x @ V2t ) @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
                @ ( c_2Ebinary__ieee_2Eclosest__such @ A_27t @ A_27w
                  @ ^ [V3a: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( c_2Ebool_2E_7E @ ( c_2Ewords_2Eword__lsb @ A_27t @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V3a ) ) )
                  @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w )
                  @ V1x ) ) )
          @ ( c_2Ebinary__ieee_2Ethreshold @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
          @ ^ [V4t: tyop_2Erealax_2Ereal] :
              ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Erealax_2Ereal__lt @ V1x @ ( c_2Erealax_2Ereal__neg @ V4t ) ) @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
              @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ereal_2Ereal__gt @ V1x @ V4t ) @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
                @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w
                  @ ( c_2Epred__set_2EGSPEC @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                    @ ^ [V5a: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ $o @ V5a @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ V5a ) @ ( c_2Ereal_2Ereal__ge @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V5a ) @ V1x ) ) ) )
                  @ V1x ) ) )
          @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
          @ ^ [V6t: tyop_2Erealax_2Ereal] :
              ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Erealax_2Ereal__lt @ V1x @ ( c_2Erealax_2Ereal__neg @ V6t ) ) @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
              @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ereal_2Ereal__gt @ V1x @ V6t ) @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
                @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w
                  @ ( c_2Epred__set_2EGSPEC @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                    @ ^ [V7a: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ $o @ V7a @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ V7a ) @ ( c_2Ereal_2Ereal__lte @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V7a ) @ V1x ) ) ) )
                  @ V1x ) ) )
          @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
          @ ^ [V8t: tyop_2Erealax_2Ereal] :
              ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Erealax_2Ereal__lt @ V1x @ ( c_2Erealax_2Ereal__neg @ V8t ) ) @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
              @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ereal_2Ereal__gt @ V1x @ V8t ) @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
                @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w
                  @ ( c_2Epred__set_2EGSPEC @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                    @ ^ [V9a: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ $o @ V9a @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ V9a ) @ ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Eabs @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V9a ) ) @ ( c_2Ereal_2Eabs @ V1x ) ) ) ) )
                  @ V1x ) ) )
          @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eintegral__round__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Erealax_2Ereal] :
      ( ( c_2Ebinary__ieee_2Eintegral__round @ A_27t @ A_27w @ V0mode @ V1x )
      = ( c_2Ebinary__ieee_2Erounding__CASE @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V0mode
        @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
          @ ^ [V2t: tyop_2Erealax_2Ereal] :
              ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ereal_2Ereal__lte @ V1x @ ( c_2Erealax_2Ereal__neg @ V2t ) ) @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
              @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ereal_2Ereal__ge @ V1x @ V2t ) @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
                @ ( c_2Ebinary__ieee_2Eclosest__such @ A_27t @ A_27w
                  @ ^ [V3a: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                      ( c_2Ebool_2E_3F @ tyop_2Enum_2Enum
                      @ ^ [V4n: tyop_2Enum_2Enum] : ( c_2Ebool_2E_2F_5C @ ( c_2Earithmetic_2EEVEN @ V4n ) @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ ( c_2Ereal_2Eabs @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V3a ) ) @ ( c_2Ereal_2Ereal__of__num @ V4n ) ) ) )
                  @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w )
                  @ V1x ) ) )
          @ ( c_2Ebinary__ieee_2Ethreshold @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
          @ ^ [V5t: tyop_2Erealax_2Ereal] :
              ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Erealax_2Ereal__lt @ V1x @ ( c_2Erealax_2Ereal__neg @ V5t ) ) @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
              @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ereal_2Ereal__gt @ V1x @ V5t ) @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
                @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w
                  @ ( c_2Epred__set_2EGSPEC @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                    @ ^ [V6a: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ $o @ V6a @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w @ V6a ) @ ( c_2Ereal_2Ereal__ge @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V6a ) @ V1x ) ) ) )
                  @ V1x ) ) )
          @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
          @ ^ [V7t: tyop_2Erealax_2Ereal] :
              ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Erealax_2Ereal__lt @ V1x @ ( c_2Erealax_2Ereal__neg @ V7t ) ) @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
              @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ereal_2Ereal__gt @ V1x @ V7t ) @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
                @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w
                  @ ( c_2Epred__set_2EGSPEC @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                    @ ^ [V8a: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ $o @ V8a @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w @ V8a ) @ ( c_2Ereal_2Ereal__lte @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V8a ) @ V1x ) ) ) )
                  @ V1x ) ) )
          @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
          @ ^ [V9t: tyop_2Erealax_2Ereal] :
              ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Erealax_2Ereal__lt @ V1x @ ( c_2Erealax_2Ereal__neg @ V9t ) ) @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
              @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ereal_2Ereal__gt @ V1x @ V9t ) @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
                @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w
                  @ ( c_2Epred__set_2EGSPEC @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                    @ ^ [V10a: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ $o @ V10a @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w @ V10a ) @ ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Eabs @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V10a ) ) @ ( c_2Ereal_2Eabs @ V1x ) ) ) ) )
                  @ V1x ) ) )
          @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efp__op__TY__DEF,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
    ? [V0rep: ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) > ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )] :
      ( c_2Ebool_2ETYPE__DEFINITION @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w )
      @ ^ [V1a0_27: tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) )] :
          ( c_2Ebool_2E_21 @ ( ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) > $o )
          @ ^ [V2_27fp__op_27: ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) > $o] :
              ( c_2Emin_2E_3D_3D_3E
              @ ( c_2Ebool_2E_21 @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
                @ ^ [V3a0_27: tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) )] :
                    ( c_2Emin_2E_3D_3D_3E
                    @ ( c_2Ebool_2E_5C_2F
                      @ ( c_2Ebool_2E_3F @ tyop_2Ebinary__ieee_2Erounding
                        @ ^ [V4a0: tyop_2Ebinary__ieee_2Erounding] :
                            ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                            @ ^ [V5a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ V3a0_27
                                @ ( ^ [V6a0: tyop_2Ebinary__ieee_2Erounding,V7a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                      ( c_2Eind__type_2ECONSTR @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ c_2Enum_2E0 @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V6a0 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V7a1 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
                                      @ ^ [V8n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                  @ V4a0
                                  @ V5a1 ) ) ) )
                      @ ( c_2Ebool_2E_5C_2F
                        @ ( c_2Ebool_2E_3F @ tyop_2Ebinary__ieee_2Erounding
                          @ ^ [V9a0: tyop_2Ebinary__ieee_2Erounding] :
                              ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                              @ ^ [V10a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                  ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                  @ ^ [V11a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                      ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ V3a0_27
                                      @ ( ^ [V12a0: tyop_2Ebinary__ieee_2Erounding,V13a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V14a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                            ( c_2Eind__type_2ECONSTR @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Enum_2ESUC @ c_2Enum_2E0 ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V12a0 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V13a1 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V14a2 @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
                                            @ ^ [V15n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                        @ V9a0
                                        @ V10a1
                                        @ V11a2 ) ) ) ) )
                        @ ( c_2Ebool_2E_5C_2F
                          @ ( c_2Ebool_2E_3F @ tyop_2Ebinary__ieee_2Erounding
                            @ ^ [V16a0: tyop_2Ebinary__ieee_2Erounding] :
                                ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                @ ^ [V17a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                    ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                    @ ^ [V18a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                        ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ V3a0_27
                                        @ ( ^ [V19a0: tyop_2Ebinary__ieee_2Erounding,V20a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V21a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                              ( c_2Eind__type_2ECONSTR @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ c_2Enum_2E0 ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V19a0 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V20a1 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V21a2 @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
                                              @ ^ [V22n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                          @ V16a0
                                          @ V17a1
                                          @ V18a2 ) ) ) ) )
                          @ ( c_2Ebool_2E_5C_2F
                            @ ( c_2Ebool_2E_3F @ tyop_2Ebinary__ieee_2Erounding
                              @ ^ [V23a0: tyop_2Ebinary__ieee_2Erounding] :
                                  ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                  @ ^ [V24a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                      ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                      @ ^ [V25a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                          ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ V3a0_27
                                          @ ( ^ [V26a0: tyop_2Ebinary__ieee_2Erounding,V27a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V28a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                                ( c_2Eind__type_2ECONSTR @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ c_2Enum_2E0 ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V26a0 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V27a1 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V28a2 @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
                                                @ ^ [V29n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                            @ V23a0
                                            @ V24a1
                                            @ V25a2 ) ) ) ) )
                            @ ( c_2Ebool_2E_5C_2F
                              @ ( c_2Ebool_2E_3F @ tyop_2Ebinary__ieee_2Erounding
                                @ ^ [V30a0: tyop_2Ebinary__ieee_2Erounding] :
                                    ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                    @ ^ [V31a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                        ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                        @ ^ [V32a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                            ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ V3a0_27
                                            @ ( ^ [V33a0: tyop_2Ebinary__ieee_2Erounding,V34a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V35a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                                  ( c_2Eind__type_2ECONSTR @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ c_2Enum_2E0 ) ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V33a0 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V34a1 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V35a2 @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
                                                  @ ^ [V36n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                              @ V30a0
                                              @ V31a1
                                              @ V32a2 ) ) ) ) )
                              @ ( c_2Ebool_2E_5C_2F
                                @ ( c_2Ebool_2E_3F @ tyop_2Ebinary__ieee_2Erounding
                                  @ ^ [V37a0: tyop_2Ebinary__ieee_2Erounding] :
                                      ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                      @ ^ [V38a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                          ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                          @ ^ [V39a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                              ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                              @ ^ [V40a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                                  ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ V3a0_27
                                                  @ ( ^ [V41a0: tyop_2Ebinary__ieee_2Erounding,V42a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V43a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V44a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                                        ( c_2Eind__type_2ECONSTR @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ c_2Enum_2E0 ) ) ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V41a0 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V42a1 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V43a2 @ V44a3 ) ) )
                                                        @ ^ [V45n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                                    @ V37a0
                                                    @ V38a1
                                                    @ V39a2
                                                    @ V40a3 ) ) ) ) ) )
                                @ ( c_2Ebool_2E_3F @ tyop_2Ebinary__ieee_2Erounding
                                  @ ^ [V46a0: tyop_2Ebinary__ieee_2Erounding] :
                                      ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                      @ ^ [V47a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                          ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                          @ ^ [V48a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                              ( c_2Ebool_2E_3F @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                              @ ^ [V49a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                                  ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ V3a0_27
                                                  @ ( ^ [V50a0: tyop_2Ebinary__ieee_2Erounding,V51a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V52a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V53a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
                                                        ( c_2Eind__type_2ECONSTR @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ c_2Enum_2E0 ) ) ) ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V50a0 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V51a1 @ ( c_2Epair_2E_2C @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V52a2 @ V53a3 ) ) )
                                                        @ ^ [V54n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Erounding @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Epair_2Eprod @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                                    @ V46a0
                                                    @ V47a1
                                                    @ V48a2
                                                    @ V49a3 ) ) ) ) ) ) ) ) ) ) ) )
                    @ ( V2_27fp__op_27 @ V3a0_27 ) ) )
              @ ( V2_27fp__op_27 @ V1a0_27 ) ) )
      @ V0rep ) ).

thf(thm_2Ebinary__ieee_2Efp__op__case__def,axiom,
    ! [A_27a: $tType,A_27t: $tType,A_27w: $tType] :
      ( ! [V0a0: tyop_2Ebinary__ieee_2Erounding,V1a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2f: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V3f1: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V4f2: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V5f3: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V6f4: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V7f5: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V8f6: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
          ( ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V0a0 @ V1a1 ) @ V2f @ V3f1 @ V4f2 @ V5f3 @ V6f4 @ V7f5 @ V8f6 )
          = ( V2f @ V0a0 @ V1a1 ) )
      & ! [V9a0: tyop_2Ebinary__ieee_2Erounding,V10a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V11a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V12f: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V13f1: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V14f2: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V15f3: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V16f4: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V17f5: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V18f6: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
          ( ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V9a0 @ V10a1 @ V11a2 ) @ V12f @ V13f1 @ V14f2 @ V15f3 @ V16f4 @ V17f5 @ V18f6 )
          = ( V13f1 @ V9a0 @ V10a1 @ V11a2 ) )
      & ! [V19a0: tyop_2Ebinary__ieee_2Erounding,V20a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V21a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V22f: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V23f1: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V24f2: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V25f3: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V26f4: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V27f5: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V28f6: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
          ( ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V19a0 @ V20a1 @ V21a2 ) @ V22f @ V23f1 @ V24f2 @ V25f3 @ V26f4 @ V27f5 @ V28f6 )
          = ( V24f2 @ V19a0 @ V20a1 @ V21a2 ) )
      & ! [V29a0: tyop_2Ebinary__ieee_2Erounding,V30a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V31a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V32f: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V33f1: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V34f2: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V35f3: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V36f4: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V37f5: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V38f6: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
          ( ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V29a0 @ V30a1 @ V31a2 ) @ V32f @ V33f1 @ V34f2 @ V35f3 @ V36f4 @ V37f5 @ V38f6 )
          = ( V35f3 @ V29a0 @ V30a1 @ V31a2 ) )
      & ! [V39a0: tyop_2Ebinary__ieee_2Erounding,V40a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V41a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V42f: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V43f1: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V44f2: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V45f3: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V46f4: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V47f5: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V48f6: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
          ( ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V39a0 @ V40a1 @ V41a2 ) @ V42f @ V43f1 @ V44f2 @ V45f3 @ V46f4 @ V47f5 @ V48f6 )
          = ( V46f4 @ V39a0 @ V40a1 @ V41a2 ) )
      & ! [V49a0: tyop_2Ebinary__ieee_2Erounding,V50a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V51a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V52a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V53f: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V54f1: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V55f2: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V56f3: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V57f4: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V58f5: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V59f6: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
          ( ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V49a0 @ V50a1 @ V51a2 @ V52a3 ) @ V53f @ V54f1 @ V55f2 @ V56f3 @ V57f4 @ V58f5 @ V59f6 )
          = ( V58f5 @ V49a0 @ V50a1 @ V51a2 @ V52a3 ) )
      & ! [V60a0: tyop_2Ebinary__ieee_2Erounding,V61a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V62a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V63a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V64f: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V65f1: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V66f2: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V67f3: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V68f4: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V69f5: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V70f6: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
          ( ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V60a0 @ V61a1 @ V62a2 @ V63a3 ) @ V64f @ V65f1 @ V66f2 @ V67f3 @ V68f4 @ V69f5 @ V70f6 )
          = ( V70f6 @ V60a0 @ V61a1 @ V62a2 @ V63a3 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efp__op__size__def,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ! [V0f: A_27t > tyop_2Enum_2Enum,V1f1: A_27w > tyop_2Enum_2Enum,V2a0: tyop_2Ebinary__ieee_2Erounding,V3a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w @ V0f @ V1f1 @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V2a0 @ V3a1 ) )
          = ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Erounding__size @ V2a0 ) @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V0f @ V1f1 @ V3a1 ) ) ) )
      & ! [V4f: A_27t > tyop_2Enum_2Enum,V5f1: A_27w > tyop_2Enum_2Enum,V6a0: tyop_2Ebinary__ieee_2Erounding,V7a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V8a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w @ V4f @ V5f1 @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V6a0 @ V7a1 @ V8a2 ) )
          = ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Erounding__size @ V6a0 ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V4f @ V5f1 @ V7a1 ) @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V4f @ V5f1 @ V8a2 ) ) ) ) )
      & ! [V9f: A_27t > tyop_2Enum_2Enum,V10f1: A_27w > tyop_2Enum_2Enum,V11a0: tyop_2Ebinary__ieee_2Erounding,V12a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V13a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w @ V9f @ V10f1 @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V11a0 @ V12a1 @ V13a2 ) )
          = ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Erounding__size @ V11a0 ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V9f @ V10f1 @ V12a1 ) @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V9f @ V10f1 @ V13a2 ) ) ) ) )
      & ! [V14f: A_27t > tyop_2Enum_2Enum,V15f1: A_27w > tyop_2Enum_2Enum,V16a0: tyop_2Ebinary__ieee_2Erounding,V17a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V18a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w @ V14f @ V15f1 @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V16a0 @ V17a1 @ V18a2 ) )
          = ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Erounding__size @ V16a0 ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V14f @ V15f1 @ V17a1 ) @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V14f @ V15f1 @ V18a2 ) ) ) ) )
      & ! [V19f: A_27t > tyop_2Enum_2Enum,V20f1: A_27w > tyop_2Enum_2Enum,V21a0: tyop_2Ebinary__ieee_2Erounding,V22a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V23a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w @ V19f @ V20f1 @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V21a0 @ V22a1 @ V23a2 ) )
          = ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Erounding__size @ V21a0 ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V19f @ V20f1 @ V22a1 ) @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V19f @ V20f1 @ V23a2 ) ) ) ) )
      & ! [V24f: A_27t > tyop_2Enum_2Enum,V25f1: A_27w > tyop_2Enum_2Enum,V26a0: tyop_2Ebinary__ieee_2Erounding,V27a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V28a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V29a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w @ V24f @ V25f1 @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V26a0 @ V27a1 @ V28a2 @ V29a3 ) )
          = ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Erounding__size @ V26a0 ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V24f @ V25f1 @ V27a1 ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V24f @ V25f1 @ V28a2 ) @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V24f @ V25f1 @ V29a3 ) ) ) ) ) )
      & ! [V30f: A_27t > tyop_2Enum_2Enum,V31f1: A_27w > tyop_2Enum_2Enum,V32a0: tyop_2Ebinary__ieee_2Erounding,V33a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V34a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V35a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w @ V30f @ V31f1 @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V32a0 @ V33a1 @ V34a2 @ V35a3 ) )
          = ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Erounding__size @ V32a0 ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V30f @ V31f1 @ V33a1 ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V30f @ V31f1 @ V34a2 ) @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w @ V30f @ V31f1 @ V35a3 ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__some__qnan__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ V0fp__op )
      = ( c_2Emin_2E_40 @ ( ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
        @ ^ [V1f: ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )] :
            ( c_2Ebool_2ELET @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ $o
            @ ^ [V2qnan: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ V2qnan ) @ ( c_2Ebool_2E_7E @ ( c_2Ebinary__ieee_2Efloat__is__signalling @ A_27t @ A_27w @ V2qnan ) ) )
            @ ( V1f @ V0fp__op ) )
        @ V0fp__op ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__round__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1toneg: $o,V2r: tyop_2Erealax_2Ereal] :
      ( ( c_2Ebinary__ieee_2Efloat__round @ A_27t @ A_27w @ V0mode @ V1toneg @ V2r )
      = ( c_2Ebool_2ELET @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
        @ ^ [V3x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ V3x ) @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V1toneg @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ V3x )
        @ ( c_2Ebinary__ieee_2Eround @ A_27t @ A_27w @ V0mode @ V2r ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__round__with__flags__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1to__neg: $o,V2r: tyop_2Erealax_2Ereal] :
      ( ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w @ V0mode @ V1to__neg @ V2r )
      = ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
        @ ( c_2Ebool_2ELET @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Erealax_2Ereal > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
          @ ^ [V3x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V4a: tyop_2Erealax_2Ereal] :
              ( c_2Ebool_2ELET @ $o @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
              @ ^ [V5inexact: $o] : ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V3x ) @ ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ewords_2EINT__MIN @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) @ V4a ) ) ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ ( c_2Ebool_2E_2F_5C @ V5inexact @ ( c_2Erealax_2Ereal__lt @ V4a @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ewords_2EINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) ) ) ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ ( c_2Ebool_2E_2F_5C @ V5inexact @ ( c_2Ewords_2Eword__ls @ ( tyop_2Esum_2Esum @ A_27w @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ ( tyop_2Esum_2Esum @ A_27w @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__round @ A_27t @ ( tyop_2Esum_2Esum @ A_27w @ tyop_2Eone_2Eone ) @ V0mode @ V1to__neg @ V2r ) ) @ ( c_2Ewords_2En2w @ ( tyop_2Esum_2Esum @ A_27w @ tyop_2Eone_2Eone ) @ ( c_2Ewords_2EINT__MIN @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) ) ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V5inexact ) @ c_2Ebinary__ieee_2Eclear__flags ) ) ) ) @ V3x )
              @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V3x ) @ ( c_2Ebinary__ieee_2EFloat @ V2r ) ) ) )
          @ ( c_2Ebinary__ieee_2Efloat__round @ A_27t @ A_27w @ V0mode @ V1to__neg @ V2r ) )
        @ ( c_2Ereal_2Eabs @ V2r ) ) ) ).

thf(thm_2Ebinary__ieee_2Echeck__for__signalling__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0l: tyop_2Elist_2Elist @ ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b )] :
      ( ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27a @ A_27b @ V0l )
      = ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ ( c_2Elist_2EEXISTS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ ( c_2Ebinary__ieee_2Efloat__is__signalling @ A_27a @ A_27b ) @ V0l ) ) @ c_2Ebinary__ieee_2Eclear__flags ) ) ).

thf(thm_2Ebinary__ieee_2Ereal__to__float__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0m: tyop_2Ebinary__ieee_2Erounding] :
      ( ( c_2Ebinary__ieee_2Ereal__to__float @ A_27a @ A_27b @ V0m )
      = ( c_2Ebinary__ieee_2Efloat__round @ A_27a @ A_27b @ V0m @ ( c_2Emin_2E_3D @ tyop_2Ebinary__ieee_2Erounding @ V0m @ c_2Ebinary__ieee_2EroundTowardNegative ) ) ) ).

thf(thm_2Ebinary__ieee_2Ereal__to__float__with__flags__def,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0m: tyop_2Ebinary__ieee_2Erounding] :
      ( ( c_2Ebinary__ieee_2Ereal__to__float__with__flags @ A_27a @ A_27b @ V0m )
      = ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27a @ A_27b @ V0m @ ( c_2Emin_2E_3D @ tyop_2Ebinary__ieee_2Erounding @ V0m @ c_2Ebinary__ieee_2EroundTowardNegative ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__round__to__integral__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__round__to__integral @ A_27t @ A_27w @ V0mode @ V1x )
      = ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V1x )
        @ ^ [V2r: tyop_2Erealax_2Ereal] : ( c_2Ebinary__ieee_2Eintegral__round @ A_27t @ A_27w @ V0mode @ V2r )
        @ V1x
        @ V1x ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__to__int__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__to__int @ A_27t @ A_27w @ V0mode @ V1x )
      = ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Eoption_2Eoption @ tyop_2Einteger_2Eint ) @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V1x )
        @ ^ [V2r: tyop_2Erealax_2Ereal] :
            ( c_2Eoption_2ESOME @ tyop_2Einteger_2Eint
            @ ( c_2Ebinary__ieee_2Erounding__CASE @ tyop_2Einteger_2Eint @ V0mode
              @ ( c_2Ebool_2ELET @ tyop_2Einteger_2Eint @ tyop_2Einteger_2Eint
                @ ^ [V3f: tyop_2Einteger_2Eint] :
                    ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ tyop_2Einteger_2Eint
                    @ ^ [V4df: tyop_2Erealax_2Ereal] : ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Ebool_2E_5C_2F @ ( c_2Erealax_2Ereal__lt @ V4df @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V4df @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Earithmetic_2EEVEN @ ( c_2Einteger_2ENum @ ( c_2Einteger_2EABS @ V3f ) ) ) ) ) @ V3f @ ( c_2Eintreal_2EINT__CEILING @ V2r ) )
                    @ ( c_2Ereal_2Eabs @ ( c_2Ereal_2Ereal__sub @ V2r @ ( c_2Eintreal_2Ereal__of__int @ V3f ) ) ) )
                @ ( c_2Eintreal_2EINT__FLOOR @ V2r ) )
              @ ( c_2Eintreal_2EINT__CEILING @ V2r )
              @ ( c_2Eintreal_2EINT__FLOOR @ V2r )
              @ ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Eintreal_2EINT__CEILING @ V2r ) @ ( c_2Eintreal_2EINT__FLOOR @ V2r ) ) ) )
        @ ( c_2Eoption_2ENONE @ tyop_2Einteger_2Eint )
        @ ( c_2Eoption_2ENONE @ tyop_2Einteger_2Eint ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__sqrt__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__sqrt @ A_27t @ A_27w @ V0mode @ V1x )
      = ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) )
        @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V1x )
          @ ^ [V2r: tyop_2Erealax_2Ereal] : ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w @ V0mode @ c_2Ebool_2EF @ ( c_2Etransc_2Esqrt @ V2r ) )
          @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
          @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V1x @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V0mode @ V1x ) ) ) )
        @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Einvalidop__flags @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V0mode @ V1x ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__add__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__add @ A_27t @ A_27w @ V0mode @ V1x @ V2y )
      = ( c_2Epair_2Epair__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ tyop_2Ebinary__ieee_2Efloat__value @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Efloat__value @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V2y ) )
        @ ^ [V3v: tyop_2Ebinary__ieee_2Efloat__value,V4v1: tyop_2Ebinary__ieee_2Efloat__value] :
            ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V3v
            @ ^ [V5r1: tyop_2Erealax_2Ereal] :
                ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V4v1
                @ ^ [V6r2: tyop_2Erealax_2Ereal] : ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w @ V0mode @ ( c_2Ebool_2ECOND @ $o @ ( c_2Ebool_2E_2F_5C @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V5r1 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V6r2 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) ) ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Emin_2E_3D @ tyop_2Ebinary__ieee_2Erounding @ V0mode @ c_2Ebinary__ieee_2EroundTowardNegative ) ) @ ( c_2Erealax_2Ereal__add @ V5r1 @ V6r2 ) )
                @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ V2y )
                @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) )
            @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V4v1
              @ ^ [V7v7: tyop_2Erealax_2Ereal] : ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ V1x )
              @ ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ V1x ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Einvalidop__flags @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) )
              @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) )
            @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V1x @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__sub__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__sub @ A_27t @ A_27w @ V0mode @ V1x @ V2y )
      = ( c_2Epair_2Epair__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ tyop_2Ebinary__ieee_2Efloat__value @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Efloat__value @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V2y ) )
        @ ^ [V3v: tyop_2Ebinary__ieee_2Efloat__value,V4v1: tyop_2Ebinary__ieee_2Efloat__value] :
            ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V3v
            @ ^ [V5r1: tyop_2Erealax_2Ereal] :
                ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V4v1
                @ ^ [V6r2: tyop_2Erealax_2Ereal] : ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w @ V0mode @ ( c_2Ebool_2ECOND @ $o @ ( c_2Ebool_2E_2F_5C @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V5r1 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V6r2 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) ) ) ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Emin_2E_3D @ tyop_2Ebinary__ieee_2Erounding @ V0mode @ c_2Ebinary__ieee_2EroundTowardNegative ) ) @ ( c_2Ereal_2Ereal__sub @ V5r1 @ V6r2 ) )
                @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w @ V2y ) )
                @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) )
            @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V4v1
              @ ^ [V7v7: tyop_2Erealax_2Ereal] : ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ V1x )
              @ ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Einvalidop__flags @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ V1x ) )
              @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) )
            @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V1x @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__mul__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__mul @ A_27t @ A_27w @ V0mode @ V1x @ V2y )
      = ( c_2Epair_2Epair__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ tyop_2Ebinary__ieee_2Efloat__value @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Efloat__value @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V2y ) )
        @ ^ [V3v: tyop_2Ebinary__ieee_2Efloat__value,V4v1: tyop_2Ebinary__ieee_2Efloat__value] :
            ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V3v
            @ ^ [V5r_27: tyop_2Erealax_2Ereal] :
                ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V4v1
                @ ^ [V6r2: tyop_2Erealax_2Ereal] : ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w @ V0mode @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) ) @ ( c_2Erealax_2Ereal__mul @ V5r_27 @ V6r2 ) )
                @ ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V5r_27 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Einvalidop__flags @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) )
                @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) )
            @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V4v1
              @ ^ [V7r: tyop_2Erealax_2Ereal] : ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V7r @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Einvalidop__flags @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) )
              @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
              @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) )
            @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V1x @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__div__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__div @ A_27t @ A_27w @ V0mode @ V1x @ V2y )
      = ( c_2Epair_2Epair__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ tyop_2Ebinary__ieee_2Efloat__value @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Efloat__value @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V2y ) )
        @ ^ [V3v: tyop_2Ebinary__ieee_2Efloat__value,V4v1: tyop_2Ebinary__ieee_2Efloat__value] :
            ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V3v
            @ ^ [V5r1: tyop_2Erealax_2Ereal] :
                ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V4v1
                @ ^ [V6r2: tyop_2Erealax_2Ereal] : ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V6r2 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V5r1 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Einvalidop__flags @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Edividezero__flags @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w @ V0mode @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) ) @ ( c_2Ereal_2E_2F @ V5r1 @ V6r2 ) ) )
                @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
                @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) )
            @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V4v1
              @ ^ [V7v7: tyop_2Erealax_2Ereal] : ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebool_2ECOND @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
              @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Einvalidop__flags @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) )
              @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) )
            @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V1x @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V0mode @ V1x @ V2y ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__mul__add__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V3z: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__mul__add @ A_27t @ A_27w @ V0mode @ V1x @ V2y @ V3z )
      = ( c_2Ebool_2ELET @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
        @ ^ [V4signP: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone] :
            ( c_2Ebool_2ELET @ $o @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            @ ^ [V5infP: $o] :
                ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ V1x ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ V2y ) @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ V3z ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V1x @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V3z @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V0mode @ V1x @ V2y @ V3z ) ) )
                @ ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ V2y ) ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V2y ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V3z ) @ ( c_2Ebool_2E_2F_5C @ V5infP @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4signP @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V3z ) ) ) ) ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Einvalidop__flags @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V0mode @ V1x @ V2y @ V3z ) ) )
                  @ ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V3z ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V3z ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2E_2F_5C @ V5infP @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4signP @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                    @ ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V3z ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V3z ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Ebool_2E_2F_5C @ V5infP @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4signP @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                      @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                        @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Erealax_2Ereal > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
                          @ ^ [V6r1: tyop_2Erealax_2Ereal,V7r2: tyop_2Erealax_2Ereal] : ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w @ V0mode @ ( c_2Ebool_2ECOND @ $o @ ( c_2Ebool_2E_2F_5C @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V6r1 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V7r2 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4signP @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V3z ) ) ) ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4signP @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Emin_2E_3D @ tyop_2Ebinary__ieee_2Erounding @ V0mode @ c_2Ebinary__ieee_2EroundTowardNegative ) ) @ ( c_2Erealax_2Ereal__add @ V6r1 @ V7r2 ) )
                          @ ( c_2Erealax_2Ereal__mul @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V2y ) ) )
                        @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V3z ) ) ) ) ) )
            @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V2y ) ) )
        @ ( c_2Ewords_2Eword__xor @ tyop_2Eone_2Eone @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__mul__sub__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0mode: tyop_2Ebinary__ieee_2Erounding,V1x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V3z: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__mul__sub @ A_27t @ A_27w @ V0mode @ V1x @ V2y @ V3z )
      = ( c_2Ebool_2ELET @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
        @ ^ [V4signP: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone] :
            ( c_2Ebool_2ELET @ $o @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            @ ^ [V5infP: $o] :
                ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ V1x ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ V2y ) @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ V3z ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V1x @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V2y @ ( c_2Elist_2ECONS @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ V3z @ ( c_2Elist_2ENIL @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V0mode @ V1x @ V2y @ V3z ) ) )
                @ ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ V2y ) ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V2y ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V3z ) @ ( c_2Ebool_2E_2F_5C @ V5infP @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4signP @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V3z ) ) ) ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Einvalidop__flags @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V0mode @ V1x @ V2y @ V3z ) ) )
                  @ ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V3z ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V3z ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Ebool_2E_2F_5C @ V5infP @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4signP @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                    @ ( c_2Ebool_2ECOND @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebool_2E_2F_5C @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V3z ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V3z ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2E_2F_5C @ V5infP @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4signP @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ c_2Ebinary__ieee_2Eclear__flags @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                      @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                        @ ( c_2Ebool_2ELET @ tyop_2Erealax_2Ereal @ ( tyop_2Erealax_2Ereal > ( tyop_2Epair_2Eprod @ tyop_2Ebinary__ieee_2Eflags @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
                          @ ^ [V6r1: tyop_2Erealax_2Ereal,V7r2: tyop_2Erealax_2Ereal] : ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w @ V0mode @ ( c_2Ebool_2ECOND @ $o @ ( c_2Ebool_2E_2F_5C @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V6r1 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V7r2 @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4signP @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V3z ) ) ) ) ) @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4signP @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Emin_2E_3D @ tyop_2Ebinary__ieee_2Erounding @ V0mode @ c_2Ebinary__ieee_2EroundTowardNegative ) ) @ ( c_2Ereal_2Ereal__sub @ V6r1 @ V7r2 ) )
                          @ ( c_2Erealax_2Ereal__mul @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V2y ) ) )
                        @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ V3z ) ) ) ) ) )
            @ ( c_2Ebool_2E_5C_2F @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V2y ) ) )
        @ ( c_2Ewords_2Eword__xor @ tyop_2Eone_2Eone @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V2y ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__TY__DEF,axiom,
    ? [V0rep: tyop_2Ebinary__ieee_2Efloat__compare > tyop_2Enum_2Enum] :
      ( c_2Ebool_2ETYPE__DEFINITION @ tyop_2Enum_2Enum @ tyop_2Ebinary__ieee_2Efloat__compare
      @ ^ [V1n: tyop_2Enum_2Enum] : ( c_2Eprim__rec_2E_3C @ V1n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      @ V0rep ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__BIJ,axiom,
    ( ! [V0a: tyop_2Ebinary__ieee_2Efloat__compare] :
        ( ( c_2Ebinary__ieee_2Enum2float__compare @ ( c_2Ebinary__ieee_2Efloat__compare2num @ V0a ) )
        = V0a )
    & ! [V1r: tyop_2Enum_2Enum] :
        ( ( ^ [V2n: tyop_2Enum_2Enum] : ( c_2Eprim__rec_2E_3C @ V2n @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
          @ V1r )
      <=> ( ( c_2Ebinary__ieee_2Efloat__compare2num @ ( c_2Ebinary__ieee_2Enum2float__compare @ V1r ) )
          = V1r ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__size__def,axiom,
    ! [V0x: tyop_2Ebinary__ieee_2Efloat__compare] :
      ( ( c_2Ebinary__ieee_2Efloat__compare__size @ V0x )
      = c_2Enum_2E0 ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__CASE,axiom,
    ! [A_27a: $tType,V0x: tyop_2Ebinary__ieee_2Efloat__compare,V1v0: A_27a,V2v1: A_27a,V3v2: A_27a,V4v3: A_27a] :
      ( ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a @ V0x @ V1v0 @ V2v1 @ V3v2 @ V4v3 )
      = ( ^ [V5m: tyop_2Enum_2Enum] : ( c_2Ebool_2ECOND @ A_27a @ ( c_2Eprim__rec_2E_3C @ V5m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V1v0 @ ( c_2Ebool_2ECOND @ A_27a @ ( c_2Eprim__rec_2E_3C @ V5m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V2v1 @ ( c_2Ebool_2ECOND @ A_27a @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ V5m @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V3v2 @ V4v3 ) ) )
        @ ( c_2Ebinary__ieee_2Efloat__compare2num @ V0x ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w @ V0x @ V1y )
      = ( c_2Epair_2Epair__CASE @ tyop_2Ebinary__ieee_2Efloat__compare @ tyop_2Ebinary__ieee_2Efloat__value @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Epair_2E_2C @ tyop_2Ebinary__ieee_2Efloat__value @ tyop_2Ebinary__ieee_2Efloat__value @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V0x ) @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ V1y ) )
        @ ^ [V2v: tyop_2Ebinary__ieee_2Efloat__value,V3v1: tyop_2Ebinary__ieee_2Efloat__value] :
            ( c_2Ebinary__ieee_2Efloat__value__CASE @ tyop_2Ebinary__ieee_2Efloat__compare @ V2v
            @ ^ [V4r1: tyop_2Erealax_2Ereal] :
                ( c_2Ebinary__ieee_2Efloat__value__CASE @ tyop_2Ebinary__ieee_2Efloat__compare @ V3v1
                @ ^ [V5r2: tyop_2Erealax_2Ereal] : ( c_2Ebool_2ECOND @ tyop_2Ebinary__ieee_2Efloat__compare @ ( c_2Erealax_2Ereal__lt @ V4r1 @ V5r2 ) @ c_2Ebinary__ieee_2ELT @ ( c_2Ebool_2ECOND @ tyop_2Ebinary__ieee_2Efloat__compare @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V4r1 @ V5r2 ) @ c_2Ebinary__ieee_2EEQ @ c_2Ebinary__ieee_2EGT ) )
                @ ( c_2Ebool_2ECOND @ tyop_2Ebinary__ieee_2Efloat__compare @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1y ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ c_2Ebinary__ieee_2EGT @ c_2Ebinary__ieee_2ELT )
                @ c_2Ebinary__ieee_2EUN )
            @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ tyop_2Ebinary__ieee_2Efloat__compare @ V3v1
              @ ^ [V6v7: tyop_2Erealax_2Ereal] : ( c_2Ebool_2ECOND @ tyop_2Ebinary__ieee_2Efloat__compare @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V0x ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ c_2Ebinary__ieee_2ELT @ c_2Ebinary__ieee_2EGT )
              @ ( c_2Ebool_2ECOND @ tyop_2Ebinary__ieee_2Efloat__compare @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V0x ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1y ) ) @ c_2Ebinary__ieee_2EEQ @ ( c_2Ebool_2ECOND @ tyop_2Ebinary__ieee_2Efloat__compare @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V0x ) @ ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ c_2Ebinary__ieee_2ELT @ c_2Ebinary__ieee_2EGT ) )
              @ c_2Ebinary__ieee_2EUN )
            @ c_2Ebinary__ieee_2EUN ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__less__than__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__less__than @ A_27t @ A_27w @ V0x @ V1y )
    <=> ( ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w @ V0x @ V1y )
        = c_2Ebinary__ieee_2ELT ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__less__equal__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__less__equal @ A_27t @ A_27w @ V0x @ V1y )
      = ( c_2Ebinary__ieee_2Efloat__compare__CASE @ $o @ ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w @ V0x @ V1y ) @ c_2Ebool_2ET @ c_2Ebool_2ET @ c_2Ebool_2EF @ c_2Ebool_2EF ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__greater__than__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__greater__than @ A_27t @ A_27w @ V0x @ V1y )
    <=> ( ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w @ V0x @ V1y )
        = c_2Ebinary__ieee_2EGT ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__greater__equal__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__greater__equal @ A_27t @ A_27w @ V0x @ V1y )
      = ( c_2Ebinary__ieee_2Efloat__compare__CASE @ $o @ ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w @ V0x @ V1y ) @ c_2Ebool_2EF @ c_2Ebool_2ET @ c_2Ebool_2ET @ c_2Ebool_2EF ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__equal__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__equal @ A_27t @ A_27w @ V0x @ V1y )
    <=> ( ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w @ V0x @ V1y )
        = c_2Ebinary__ieee_2EEQ ) ) ).

thf(thm_2Ebinary__ieee_2Eexponent__boundary__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0y: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Eexponent__boundary @ A_27t @ A_27w @ V0y @ V1x )
    <=> ( ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1x )
          = ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V0y ) )
        & ( ( c_2Ewords_2Ew2n @ A_27w @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V1x ) )
          = ( c_2Earithmetic_2E_2B @ ( c_2Ewords_2Ew2n @ A_27w @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V0y ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
        & ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V1x )
            = ( c_2Ewords_2En2w @ A_27w @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
        & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V0y )
          = ( c_2Ewords_2Eword__2comp @ A_27t @ ( c_2Ewords_2En2w @ A_27t @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
        & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V1x )
          = ( c_2Ewords_2En2w @ A_27t @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__accessors,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ! [V0c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V1c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V2c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
          ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V0c @ V1c0 @ V2c1 ) )
          = V0c )
      & ! [V3c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V4c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V5c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
          ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V3c @ V4c0 @ V5c1 ) )
          = V4c0 )
      & ! [V6c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V7c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V8c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
          ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V6c @ V7c0 @ V8c1 ) )
          = V8c1 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__fn__updates,axiom,
    ! [A_27t: $tType,A_27u: $tType,A_27w: $tType,A_27x: $tType] :
      ( ! [V0f: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V1c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V2c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V3c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
          ( ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V1c @ V2c0 @ V3c1 ) )
          = ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ ( V0f @ V1c ) @ V2c0 @ V3c1 ) )
      & ! [V4f: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V5c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V6c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V7c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
          ( ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V4f @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V5c @ V6c0 @ V7c1 ) )
          = ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27x @ V5c @ ( V4f @ V6c0 ) @ V7c1 ) )
      & ! [V8f: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ),V9c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V10c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V11c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
          ( ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V8f @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V9c @ V10c0 @ V11c1 ) )
          = ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27u @ A_27w @ V9c @ V10c0 @ ( V8f @ V11c1 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__accfupds,axiom,
    ! [A_27t: $tType,A_27u: $tType,A_27w: $tType,A_27x: $tType] :
      ( ! [V0f0: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V1f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27x @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V0f0 @ V1f ) )
          = ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1f ) )
      & ! [V2f0: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ),V3f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27u @ A_27w @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V2f0 @ V3f ) )
          = ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V3f ) )
      & ! [V4f0: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V5f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V4f0 @ V5f ) )
          = ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V5f ) )
      & ! [V6f0: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ),V7f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27u @ A_27w @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V6f0 @ V7f ) )
          = ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V7f ) )
      & ! [V8f0: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V9f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V8f0 @ V9f ) )
          = ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V9f ) )
      & ! [V10f0: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V11f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27x @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V10f0 @ V11f ) )
          = ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V11f ) )
      & ! [V12f0: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V13f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V12f0 @ V13f ) )
          = ( V12f0 @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V13f ) ) )
      & ! [V14f0: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V15f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27x @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V14f0 @ V15f ) )
          = ( V14f0 @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V15f ) ) )
      & ! [V16f0: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ),V17f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27u @ A_27w @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V16f0 @ V17f ) )
          = ( V16f0 @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V17f ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__fupdfupds,axiom,
    ! [A_27t: $tType,A_27u: $tType,A_27v: $tType,A_27w: $tType,A_27x: $tType,A_27y: $tType] :
      ( ! [V0g: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V1f0: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V2f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V1f0 @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V0g @ V2f ) )
          = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1f0 @ V0g ) @ V2f ) )
      & ! [V3g: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V4f0: ( tyop_2Efcp_2Ecart @ $o @ A_27x ) > ( tyop_2Efcp_2Ecart @ $o @ A_27y ),V5f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27x @ A_27y @ V4f0 @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V3g @ V5f ) )
          = ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27y @ ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27y ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27x ) @ V4f0 @ V3g ) @ V5f ) )
      & ! [V6g: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ),V7f0: ( tyop_2Efcp_2Ecart @ $o @ A_27u ) > ( tyop_2Efcp_2Ecart @ $o @ A_27v ),V8f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27u @ A_27v @ A_27w @ V7f0 @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V6g @ V8f ) )
          = ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27v @ A_27w @ ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27v ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27u ) @ V7f0 @ V6g ) @ V8f ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__fupdfupds__comp,axiom,
    ! [A_27a: $tType,A_27t: $tType,A_27u: $tType,A_27v: $tType,A_27w: $tType,A_27x: $tType,A_27y: $tType] :
      ( ! [V0g: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V1f0: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )] :
          ( ( c_2Ecombin_2Eo @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V1f0 ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V0g ) )
          = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1f0 @ V0g ) ) )
      & ! [V2h: A_27a > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ),V3g: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V4f0: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone )] :
          ( ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V4f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V3g ) @ V2h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V4f0 @ V3g ) ) @ V2h ) )
      & ! [V5g: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V6f0: ( tyop_2Efcp_2Ecart @ $o @ A_27x ) > ( tyop_2Efcp_2Ecart @ $o @ A_27y )] :
          ( ( c_2Ecombin_2Eo @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27y ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27x @ A_27y @ V6f0 ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V5g ) )
          = ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27y @ ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27y ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27x ) @ V6f0 @ V5g ) ) )
      & ! [V7h: A_27a > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ),V8g: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V9f0: ( tyop_2Efcp_2Ecart @ $o @ A_27x ) > ( tyop_2Efcp_2Ecart @ $o @ A_27y )] :
          ( ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27y ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27x @ A_27y @ V9f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V8g ) @ V7h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27y ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27y @ ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27y ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27x ) @ V9f0 @ V8g ) ) @ V7h ) )
      & ! [V10g: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ),V11f0: ( tyop_2Efcp_2Ecart @ $o @ A_27u ) > ( tyop_2Efcp_2Ecart @ $o @ A_27v )] :
          ( ( c_2Ecombin_2Eo @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27v @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27u @ A_27v @ A_27w @ V11f0 ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V10g ) )
          = ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27v @ A_27w @ ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27v ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27u ) @ V11f0 @ V10g ) ) )
      & ! [V12h: A_27a > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ),V13g: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ),V14f0: ( tyop_2Efcp_2Ecart @ $o @ A_27u ) > ( tyop_2Efcp_2Ecart @ $o @ A_27v )] :
          ( ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27v @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27u @ A_27v @ A_27w @ V14f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V13g ) @ V12h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27v @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27v @ A_27w @ ( c_2Ecombin_2Eo @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27v ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27u ) @ V14f0 @ V13g ) ) @ V12h ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__fupdcanon,axiom,
    ! [A_27t: $tType,A_27u: $tType,A_27w: $tType,A_27x: $tType] :
      ( ! [V0g: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V1f0: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V2f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V1f0 @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V0g @ V2f ) )
          = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27x @ V0g @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V1f0 @ V2f ) ) )
      & ! [V3g: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V4f0: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ),V5f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V4f0 @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V3g @ V5f ) )
          = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27w @ V3g @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V4f0 @ V5f ) ) )
      & ! [V6g: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V7f0: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u ),V8f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27x @ V7f0 @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V6g @ V8f ) )
          = ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x @ V6g @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V7f0 @ V8f ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__fupdcanon__comp,axiom,
    ! [A_27a: $tType,A_27t: $tType,A_27u: $tType,A_27w: $tType,A_27x: $tType] :
      ( ! [V0g: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V1f0: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x )] :
          ( ( c_2Ecombin_2Eo @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V1f0 ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V0g ) )
          = ( c_2Ecombin_2Eo @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27x @ V0g ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V1f0 ) ) )
      & ! [V2h: A_27a > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ),V3g: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V4f0: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x )] :
          ( ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V4f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V3g ) @ V2h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27x @ V3g ) @ ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V4f0 ) @ V2h ) ) )
      & ! [V5g: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V6f0: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u )] :
          ( ( c_2Ecombin_2Eo @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V6f0 ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V5g ) )
          = ( c_2Ecombin_2Eo @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27w @ V5g ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V6f0 ) ) )
      & ! [V7h: A_27a > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ),V8g: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ),V9f0: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u )] :
          ( ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V9f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w @ V8g ) @ V7h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27w @ V8g ) @ ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V9f0 ) @ V7h ) ) )
      & ! [V10g: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V11f0: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u )] :
          ( ( c_2Ecombin_2Eo @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27x @ V11f0 ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V10g ) )
          = ( c_2Ecombin_2Eo @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x @ V10g ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V11f0 ) ) )
      & ! [V12h: A_27a > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ),V13g: ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27x ),V14f0: ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > ( tyop_2Efcp_2Ecart @ $o @ A_27u )] :
          ( ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27x @ V14f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x @ V13g ) @ V12h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x @ V13g ) @ ( c_2Ecombin_2Eo @ A_27a @ ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ V14f0 ) @ V12h ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__component__equality,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0f1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1f2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( V0f1 = V1f2 )
    <=> ( ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V0f1 )
          = ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ V1f2 ) )
        & ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V0f1 )
          = ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ V1f2 ) )
        & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V0f1 )
          = ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ V1f2 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__updates__eq__literal,axiom,
    ! [A_27t: $tType,A_27u: $tType,A_27w: $tType,A_27x: $tType,V0f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1c1: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V2c0: tyop_2Efcp_2Ecart @ $o @ A_27x,V3c: tyop_2Efcp_2Ecart @ $o @ A_27u] :
      ( ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1c1 ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27x ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ V2c0 ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27u ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ V3c ) @ V0f ) ) )
      = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1c1 ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27x ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ V2c0 ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27u ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ V3c ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__literal__nchotomy,axiom,
    ! [A_27t: $tType,A_27u: $tType,A_27w: $tType,A_27x: $tType,V0f: tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27x] :
    ? [V1c1: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V2c0: tyop_2Efcp_2Ecart @ $o @ A_27x,V3c: tyop_2Efcp_2Ecart @ $o @ A_27u] :
      ( V0f
      = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V1c1 ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27x ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ V2c0 ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27u ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ V3c ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2EFORALL__float,axiom,
    ! [A_27t: $tType,A_27u: $tType,A_27w: $tType,A_27x: $tType,V0P: ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) > $o] :
      ( ! [V1f: tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27x] : ( V0P @ V1f )
    <=> ! [V2c1: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V3c0: tyop_2Efcp_2Ecart @ $o @ A_27x,V4c: tyop_2Efcp_2Ecart @ $o @ A_27u] : ( V0P @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V2c1 ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27x ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ V3c0 ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27u ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ V4c ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2EEXISTS__float,axiom,
    ! [A_27t: $tType,A_27u: $tType,A_27w: $tType,A_27x: $tType,V0P: ( tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) > $o] :
      ( ? [V1f: tyop_2Ebinary__ieee_2Efloat @ A_27u @ A_27x] : ( V0P @ V1f )
    <=> ? [V2c1: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V3c0: tyop_2Efcp_2Ecart @ $o @ A_27x,V4c: tyop_2Efcp_2Ecart @ $o @ A_27u] : ( V0P @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V2c1 ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27x ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ V3c0 ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27u ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ V4c ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__literal__11,axiom,
    ! [A_27t: $tType,A_27u: $tType,A_27w: $tType,A_27x: $tType,V0c11: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V1c01: tyop_2Efcp_2Ecart @ $o @ A_27x,V2c1: tyop_2Efcp_2Ecart @ $o @ A_27u,V3c12: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V4c02: tyop_2Efcp_2Ecart @ $o @ A_27x,V5c2: tyop_2Efcp_2Ecart @ $o @ A_27u] :
      ( ( ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V0c11 ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27x ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ V1c01 ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27u ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ V2c1 ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
        = ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) @ V3c12 ) @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27x ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ V4c02 ) @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w @ ( c_2Ecombin_2EK @ ( tyop_2Efcp_2Ecart @ $o @ A_27u ) @ ( tyop_2Efcp_2Ecart @ $o @ A_27t ) @ V5c2 ) @ ( c_2Ebool_2EARB @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
    <=> ( ( V0c11 = V3c12 )
        & ( V1c01 = V4c02 )
        & ( V2c1 = V5c2 ) ) ) ).

thf(thm_2Ebinary__ieee_2Edatatype__float,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0record: ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > $o,V1float: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2Significand: tyop_2Efcp_2Ecart @ $o @ A_27t,V3Sign: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V4Exponent: tyop_2Efcp_2Ecart @ $o @ A_27w] : ( c_2Ebool_2EDATATYPE @ $o @ ( V0record @ V1float @ V3Sign @ V4Exponent @ V2Significand ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__11,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0a0: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V1a1: tyop_2Efcp_2Ecart @ $o @ A_27w,V2a2: tyop_2Efcp_2Ecart @ $o @ A_27t,V3a0_27: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V4a1_27: tyop_2Efcp_2Ecart @ $o @ A_27w,V5a2_27: tyop_2Efcp_2Ecart @ $o @ A_27t] :
      ( ( ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V0a0 @ V1a1 @ V2a2 )
        = ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V3a0_27 @ V4a1_27 @ V5a2_27 ) )
    <=> ( ( V0a0 = V3a0_27 )
        & ( V1a1 = V4a1_27 )
        & ( V2a2 = V5a2_27 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__nchotomy,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0ff: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
    ? [V1c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V2c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V3c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
      ( V0ff
      = ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V1c @ V2c0 @ V3c1 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__Axiom,axiom,
    ! [A_27a: $tType,A_27t: $tType,A_27w: $tType,V0f: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > A_27a] :
    ? [V1fn: ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
    ! [V2a0: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V3a1: tyop_2Efcp_2Ecart @ $o @ A_27w,V4a2: tyop_2Efcp_2Ecart @ $o @ A_27t] :
      ( ( V1fn @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V2a0 @ V3a1 @ V4a2 ) )
      = ( V0f @ V2a0 @ V3a1 @ V4a2 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__induction,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0P: ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > $o] :
      ( ! [V1c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V2c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V3c1: tyop_2Efcp_2Ecart @ $o @ A_27t] : ( V0P @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V1c @ V2c0 @ V3c1 ) )
     => ! [V4f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( V0P @ V4f ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__case__cong,axiom,
    ! [A_27a: $tType,A_27t: $tType,A_27w: $tType,V0f_27: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > A_27a,V1M: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2M_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V3f: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > A_27a] :
      ( ( ( V1M = V2M_27 )
        & ! [V4a0: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V5a1: tyop_2Efcp_2Ecart @ $o @ A_27w,V6a2: tyop_2Efcp_2Ecart @ $o @ A_27t] :
            ( ( V2M_27
              = ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V4a0 @ V5a1 @ V6a2 ) )
           => ( ( V3f @ V4a0 @ V5a1 @ V6a2 )
              = ( V0f_27 @ V4a0 @ V5a1 @ V6a2 ) ) ) )
     => ( ( c_2Ebinary__ieee_2Efloat__CASE @ A_27a @ A_27t @ A_27w @ V1M @ V3f )
        = ( c_2Ebinary__ieee_2Efloat__CASE @ A_27a @ A_27t @ A_27w @ V2M_27 @ V0f_27 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__case__eq,axiom,
    ! [A_27a: $tType,A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1v: A_27a,V2f: ( tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone ) > ( tyop_2Efcp_2Ecart @ $o @ A_27w ) > ( tyop_2Efcp_2Ecart @ $o @ A_27t ) > A_27a] :
      ( ( ( c_2Ebinary__ieee_2Efloat__CASE @ A_27a @ A_27t @ A_27w @ V0x @ V2f )
        = V1v )
    <=> ? [V3c: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone,V4c0: tyop_2Efcp_2Ecart @ $o @ A_27w,V5c1: tyop_2Efcp_2Ecart @ $o @ A_27t] :
          ( ( V0x
            = ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w @ V3c @ V4c0 @ V5c1 ) )
          & ( ( V2f @ V3c @ V4c0 @ V5c1 )
            = V1v ) ) ) ).

thf(thm_2Ebinary__ieee_2Edatatype__float__value,axiom,
    ! [V0float__value: ( tyop_2Erealax_2Ereal > tyop_2Ebinary__ieee_2Efloat__value ) > tyop_2Ebinary__ieee_2Efloat__value > tyop_2Ebinary__ieee_2Efloat__value > $o] : ( c_2Ebool_2EDATATYPE @ $o @ ( V0float__value @ c_2Ebinary__ieee_2EFloat @ c_2Ebinary__ieee_2EInfinity @ c_2Ebinary__ieee_2ENaN ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__11,axiom,
    ! [V0a: tyop_2Erealax_2Ereal,V1a_27: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Ebinary__ieee_2EFloat @ V0a )
        = ( c_2Ebinary__ieee_2EFloat @ V1a_27 ) )
    <=> ( V0a = V1a_27 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__distinct,axiom,
    ( ! [V0a: tyop_2Erealax_2Ereal] :
        ( (~)
        @ ( ( c_2Ebinary__ieee_2EFloat @ V0a )
          = c_2Ebinary__ieee_2EInfinity ) )
    & ! [V1a: tyop_2Erealax_2Ereal] :
        ( (~)
        @ ( ( c_2Ebinary__ieee_2EFloat @ V1a )
          = c_2Ebinary__ieee_2ENaN ) )
    & ( (~) @ ( c_2Ebinary__ieee_2EInfinity = c_2Ebinary__ieee_2ENaN ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__nchotomy,axiom,
    ! [V0ff: tyop_2Ebinary__ieee_2Efloat__value] :
      ( ? [V1r: tyop_2Erealax_2Ereal] :
          ( V0ff
          = ( c_2Ebinary__ieee_2EFloat @ V1r ) )
      | ( V0ff = c_2Ebinary__ieee_2EInfinity )
      | ( V0ff = c_2Ebinary__ieee_2ENaN ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__Axiom,axiom,
    ! [A_27a: $tType,V0f0: tyop_2Erealax_2Ereal > A_27a,V1f1: A_27a,V2f2: A_27a] :
    ? [V3fn: tyop_2Ebinary__ieee_2Efloat__value > A_27a] :
      ( ! [V4a: tyop_2Erealax_2Ereal] :
          ( ( V3fn @ ( c_2Ebinary__ieee_2EFloat @ V4a ) )
          = ( V0f0 @ V4a ) )
      & ( ( V3fn @ c_2Ebinary__ieee_2EInfinity )
        = V1f1 )
      & ( ( V3fn @ c_2Ebinary__ieee_2ENaN )
        = V2f2 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__induction,axiom,
    ! [V0P: tyop_2Ebinary__ieee_2Efloat__value > $o] :
      ( ( ! [V1r: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Ebinary__ieee_2EFloat @ V1r ) )
        & ( V0P @ c_2Ebinary__ieee_2EInfinity )
        & ( V0P @ c_2Ebinary__ieee_2ENaN ) )
     => ! [V2f: tyop_2Ebinary__ieee_2Efloat__value] : ( V0P @ V2f ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__case__cong,axiom,
    ! [A_27a: $tType,V0v1_27: A_27a,V1v_27: A_27a,V2f_27: tyop_2Erealax_2Ereal > A_27a,V3M: tyop_2Ebinary__ieee_2Efloat__value,V4M_27: tyop_2Ebinary__ieee_2Efloat__value,V5f: tyop_2Erealax_2Ereal > A_27a,V6v: A_27a,V7v1: A_27a] :
      ( ( ( V3M = V4M_27 )
        & ! [V8a: tyop_2Erealax_2Ereal] :
            ( ( V4M_27
              = ( c_2Ebinary__ieee_2EFloat @ V8a ) )
           => ( ( V5f @ V8a )
              = ( V2f_27 @ V8a ) ) )
        & ( ( V4M_27 = c_2Ebinary__ieee_2EInfinity )
         => ( V6v = V1v_27 ) )
        & ( ( V4M_27 = c_2Ebinary__ieee_2ENaN )
         => ( V7v1 = V0v1_27 ) ) )
     => ( ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a @ V3M @ V5f @ V6v @ V7v1 )
        = ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a @ V4M_27 @ V2f_27 @ V1v_27 @ V0v1_27 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__value__case__eq,axiom,
    ! [A_27a: $tType,V0x: tyop_2Ebinary__ieee_2Efloat__value,V1v1: A_27a,V2v_27: A_27a,V3v: A_27a,V4f: tyop_2Erealax_2Ereal > A_27a] :
      ( ( ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a @ V0x @ V4f @ V3v @ V1v1 )
        = V2v_27 )
    <=> ( ? [V5r: tyop_2Erealax_2Ereal] :
            ( ( V0x
              = ( c_2Ebinary__ieee_2EFloat @ V5r ) )
            & ( ( V4f @ V5r )
              = V2v_27 ) )
        | ( ( V0x = c_2Ebinary__ieee_2EInfinity )
          & ( V3v = V2v_27 ) )
        | ( ( V0x = c_2Ebinary__ieee_2ENaN )
          & ( V1v1 = V2v_27 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__accessors,axiom,
    ( ! [V0b: $o,V1b0: $o,V2b1: $o,V3b2: $o,V4b3: $o,V5b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__DivideByZero @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b @ V1b0 @ V2b1 @ V3b2 @ V4b3 @ V5b4 ) )
        = V0b )
    & ! [V6b: $o,V7b0: $o,V8b1: $o,V9b2: $o,V10b3: $o,V11b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__InvalidOp @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V6b @ V7b0 @ V8b1 @ V9b2 @ V10b3 @ V11b4 ) )
        = V7b0 )
    & ! [V12b: $o,V13b0: $o,V14b1: $o,V15b2: $o,V16b3: $o,V17b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V12b @ V13b0 @ V14b1 @ V15b2 @ V16b3 @ V17b4 ) )
        = V14b1 )
    & ! [V18b: $o,V19b0: $o,V20b1: $o,V21b2: $o,V22b3: $o,V23b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V18b @ V19b0 @ V20b1 @ V21b2 @ V22b3 @ V23b4 ) )
        = V21b2 )
    & ! [V24b: $o,V25b0: $o,V26b1: $o,V27b2: $o,V28b3: $o,V29b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V24b @ V25b0 @ V26b1 @ V27b2 @ V28b3 @ V29b4 ) )
        = V28b3 )
    & ! [V30b: $o,V31b0: $o,V32b1: $o,V33b2: $o,V34b3: $o,V35b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V30b @ V31b0 @ V32b1 @ V33b2 @ V34b3 @ V35b4 ) )
        = V35b4 ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__fn__updates,axiom,
    ( ! [V0f: $o > $o,V1b: $o,V2b0: $o,V3b1: $o,V4b2: $o,V5b3: $o,V6b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) )
        = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ ( V0f @ V1b ) @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) )
    & ! [V7f: $o > $o,V8b: $o,V9b0: $o,V10b1: $o,V11b2: $o,V12b3: $o,V13b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V7f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V8b @ V9b0 @ V10b1 @ V11b2 @ V12b3 @ V13b4 ) )
        = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V8b @ ( V7f @ V9b0 ) @ V10b1 @ V11b2 @ V12b3 @ V13b4 ) )
    & ! [V14f: $o > $o,V15b: $o,V16b0: $o,V17b1: $o,V18b2: $o,V19b3: $o,V20b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V14f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V15b @ V16b0 @ V17b1 @ V18b2 @ V19b3 @ V20b4 ) )
        = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V15b @ V16b0 @ ( V14f @ V17b1 ) @ V18b2 @ V19b3 @ V20b4 ) )
    & ! [V21f: $o > $o,V22b: $o,V23b0: $o,V24b1: $o,V25b2: $o,V26b3: $o,V27b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V21f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V22b @ V23b0 @ V24b1 @ V25b2 @ V26b3 @ V27b4 ) )
        = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V22b @ V23b0 @ V24b1 @ ( V21f @ V25b2 ) @ V26b3 @ V27b4 ) )
    & ! [V28f: $o > $o,V29b: $o,V30b0: $o,V31b1: $o,V32b2: $o,V33b3: $o,V34b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V28f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V29b @ V30b0 @ V31b1 @ V32b2 @ V33b3 @ V34b4 ) )
        = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V29b @ V30b0 @ V31b1 @ V32b2 @ ( V28f @ V33b3 ) @ V34b4 ) )
    & ! [V35f: $o > $o,V36b: $o,V37b0: $o,V38b1: $o,V39b2: $o,V40b3: $o,V41b4: $o] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V35f @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V36b @ V37b0 @ V38b1 @ V39b2 @ V40b3 @ V41b4 ) )
        = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V36b @ V37b0 @ V38b1 @ V39b2 @ V40b3 @ ( V35f @ V41b4 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__accfupds,axiom,
    ( ! [V0f0: $o > $o,V1f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__DivideByZero @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V0f0 @ V1f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero @ V1f ) )
    & ! [V2f0: $o > $o,V3f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__DivideByZero @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V2f0 @ V3f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero @ V3f ) )
    & ! [V4f0: $o > $o,V5f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__DivideByZero @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V4f0 @ V5f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero @ V5f ) )
    & ! [V6f0: $o > $o,V7f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__DivideByZero @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V6f0 @ V7f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero @ V7f ) )
    & ! [V8f0: $o > $o,V9f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__DivideByZero @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V8f0 @ V9f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero @ V9f ) )
    & ! [V10f0: $o > $o,V11f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__InvalidOp @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V10f0 @ V11f ) )
        = ( c_2Ebinary__ieee_2Eflags__InvalidOp @ V11f ) )
    & ! [V12f0: $o > $o,V13f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__InvalidOp @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V12f0 @ V13f ) )
        = ( c_2Ebinary__ieee_2Eflags__InvalidOp @ V13f ) )
    & ! [V14f0: $o > $o,V15f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__InvalidOp @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V14f0 @ V15f ) )
        = ( c_2Ebinary__ieee_2Eflags__InvalidOp @ V15f ) )
    & ! [V16f0: $o > $o,V17f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__InvalidOp @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V16f0 @ V17f ) )
        = ( c_2Ebinary__ieee_2Eflags__InvalidOp @ V17f ) )
    & ! [V18f0: $o > $o,V19f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__InvalidOp @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V18f0 @ V19f ) )
        = ( c_2Ebinary__ieee_2Eflags__InvalidOp @ V19f ) )
    & ! [V20f0: $o > $o,V21f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V20f0 @ V21f ) )
        = ( c_2Ebinary__ieee_2Eflags__Overflow @ V21f ) )
    & ! [V22f0: $o > $o,V23f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V22f0 @ V23f ) )
        = ( c_2Ebinary__ieee_2Eflags__Overflow @ V23f ) )
    & ! [V24f0: $o > $o,V25f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V24f0 @ V25f ) )
        = ( c_2Ebinary__ieee_2Eflags__Overflow @ V25f ) )
    & ! [V26f0: $o > $o,V27f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V26f0 @ V27f ) )
        = ( c_2Ebinary__ieee_2Eflags__Overflow @ V27f ) )
    & ! [V28f0: $o > $o,V29f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V28f0 @ V29f ) )
        = ( c_2Ebinary__ieee_2Eflags__Overflow @ V29f ) )
    & ! [V30f0: $o > $o,V31f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V30f0 @ V31f ) )
        = ( c_2Ebinary__ieee_2Eflags__Precision @ V31f ) )
    & ! [V32f0: $o > $o,V33f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V32f0 @ V33f ) )
        = ( c_2Ebinary__ieee_2Eflags__Precision @ V33f ) )
    & ! [V34f0: $o > $o,V35f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V34f0 @ V35f ) )
        = ( c_2Ebinary__ieee_2Eflags__Precision @ V35f ) )
    & ! [V36f0: $o > $o,V37f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V36f0 @ V37f ) )
        = ( c_2Ebinary__ieee_2Eflags__Precision @ V37f ) )
    & ! [V38f0: $o > $o,V39f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V38f0 @ V39f ) )
        = ( c_2Ebinary__ieee_2Eflags__Precision @ V39f ) )
    & ! [V40f0: $o > $o,V41f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V40f0 @ V41f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ V41f ) )
    & ! [V42f0: $o > $o,V43f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V42f0 @ V43f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ V43f ) )
    & ! [V44f0: $o > $o,V45f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V44f0 @ V45f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ V45f ) )
    & ! [V46f0: $o > $o,V47f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V46f0 @ V47f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ V47f ) )
    & ! [V48f0: $o > $o,V49f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V48f0 @ V49f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ V49f ) )
    & ! [V50f0: $o > $o,V51f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V50f0 @ V51f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ V51f ) )
    & ! [V52f0: $o > $o,V53f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V52f0 @ V53f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ V53f ) )
    & ! [V54f0: $o > $o,V55f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V54f0 @ V55f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ V55f ) )
    & ! [V56f0: $o > $o,V57f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V56f0 @ V57f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ V57f ) )
    & ! [V58f0: $o > $o,V59f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V58f0 @ V59f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ V59f ) )
    & ! [V60f0: $o > $o,V61f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__DivideByZero @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V60f0 @ V61f ) )
        = ( V60f0 @ ( c_2Ebinary__ieee_2Eflags__DivideByZero @ V61f ) ) )
    & ! [V62f0: $o > $o,V63f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__InvalidOp @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V62f0 @ V63f ) )
        = ( V62f0 @ ( c_2Ebinary__ieee_2Eflags__InvalidOp @ V63f ) ) )
    & ! [V64f0: $o > $o,V65f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V64f0 @ V65f ) )
        = ( V64f0 @ ( c_2Ebinary__ieee_2Eflags__Overflow @ V65f ) ) )
    & ! [V66f0: $o > $o,V67f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V66f0 @ V67f ) )
        = ( V66f0 @ ( c_2Ebinary__ieee_2Eflags__Precision @ V67f ) ) )
    & ! [V68f0: $o > $o,V69f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V68f0 @ V69f ) )
        = ( V68f0 @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ V69f ) ) )
    & ! [V70f0: $o > $o,V71f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V70f0 @ V71f ) )
        = ( V70f0 @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ V71f ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__fupdfupds,axiom,
    ( ! [V0g: $o > $o,V1f0: $o > $o,V2f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V1f0 @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g @ V2f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V1f0 @ V0g ) @ V2f ) )
    & ! [V3g: $o > $o,V4f0: $o > $o,V5f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V4f0 @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V3g @ V5f ) )
        = ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V4f0 @ V3g ) @ V5f ) )
    & ! [V6g: $o > $o,V7f0: $o > $o,V8f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V7f0 @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V6g @ V8f ) )
        = ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V7f0 @ V6g ) @ V8f ) )
    & ! [V9g: $o > $o,V10f0: $o > $o,V11f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V10f0 @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V9g @ V11f ) )
        = ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V10f0 @ V9g ) @ V11f ) )
    & ! [V12g: $o > $o,V13f0: $o > $o,V14f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V13f0 @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V12g @ V14f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V13f0 @ V12g ) @ V14f ) )
    & ! [V15g: $o > $o,V16f0: $o > $o,V17f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V16f0 @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V15g @ V17f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V16f0 @ V15g ) @ V17f ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__fupdfupds__comp,axiom,
    ! [A_27a: $tType] :
      ( ! [V0g: $o > $o,V1f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V1f0 ) @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g ) )
          = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V1f0 @ V0g ) ) )
      & ! [V2h: A_27a > tyop_2Ebinary__ieee_2Eflags,V3g: $o > $o,V4f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V4f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V3g ) @ V2h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V4f0 @ V3g ) ) @ V2h ) )
      & ! [V5g: $o > $o,V6f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V6f0 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V5g ) )
          = ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V6f0 @ V5g ) ) )
      & ! [V7h: A_27a > tyop_2Ebinary__ieee_2Eflags,V8g: $o > $o,V9f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V9f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V8g ) @ V7h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V9f0 @ V8g ) ) @ V7h ) )
      & ! [V10g: $o > $o,V11f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V11f0 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V10g ) )
          = ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V11f0 @ V10g ) ) )
      & ! [V12h: A_27a > tyop_2Ebinary__ieee_2Eflags,V13g: $o > $o,V14f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V14f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V13g ) @ V12h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V14f0 @ V13g ) ) @ V12h ) )
      & ! [V15g: $o > $o,V16f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V16f0 ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V15g ) )
          = ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V16f0 @ V15g ) ) )
      & ! [V17h: A_27a > tyop_2Ebinary__ieee_2Eflags,V18g: $o > $o,V19f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V19f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V18g ) @ V17h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V19f0 @ V18g ) ) @ V17h ) )
      & ! [V20g: $o > $o,V21f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V21f0 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V20g ) )
          = ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V21f0 @ V20g ) ) )
      & ! [V22h: A_27a > tyop_2Ebinary__ieee_2Eflags,V23g: $o > $o,V24f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V24f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V23g ) @ V22h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V24f0 @ V23g ) ) @ V22h ) )
      & ! [V25g: $o > $o,V26f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V26f0 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V25g ) )
          = ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V26f0 @ V25g ) ) )
      & ! [V27h: A_27a > tyop_2Ebinary__ieee_2Eflags,V28g: $o > $o,V29f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V29f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V28g ) @ V27h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2Eo @ $o @ $o @ $o @ V29f0 @ V28g ) ) @ V27h ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__fupdcanon,axiom,
    ( ! [V0g: $o > $o,V1f0: $o > $o,V2f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V1f0 @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g @ V2f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V1f0 @ V2f ) ) )
    & ! [V3g: $o > $o,V4f0: $o > $o,V5f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V4f0 @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V3g @ V5f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V3g @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V4f0 @ V5f ) ) )
    & ! [V6g: $o > $o,V7f0: $o > $o,V8f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V7f0 @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V6g @ V8f ) )
        = ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V6g @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V7f0 @ V8f ) ) )
    & ! [V9g: $o > $o,V10f0: $o > $o,V11f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V10f0 @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V9g @ V11f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V9g @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V10f0 @ V11f ) ) )
    & ! [V12g: $o > $o,V13f0: $o > $o,V14f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V13f0 @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V12g @ V14f ) )
        = ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V12g @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V13f0 @ V14f ) ) )
    & ! [V15g: $o > $o,V16f0: $o > $o,V17f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V16f0 @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V15g @ V17f ) )
        = ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V15g @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V16f0 @ V17f ) ) )
    & ! [V18g: $o > $o,V19f0: $o > $o,V20f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V19f0 @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V18g @ V20f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V18g @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V19f0 @ V20f ) ) )
    & ! [V21g: $o > $o,V22f0: $o > $o,V23f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V22f0 @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V21g @ V23f ) )
        = ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V21g @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V22f0 @ V23f ) ) )
    & ! [V24g: $o > $o,V25f0: $o > $o,V26f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V25f0 @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V24g @ V26f ) )
        = ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V24g @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V25f0 @ V26f ) ) )
    & ! [V27g: $o > $o,V28f0: $o > $o,V29f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V28f0 @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V27g @ V29f ) )
        = ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V27g @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V28f0 @ V29f ) ) )
    & ! [V30g: $o > $o,V31f0: $o > $o,V32f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V31f0 @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V30g @ V32f ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V30g @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V31f0 @ V32f ) ) )
    & ! [V33g: $o > $o,V34f0: $o > $o,V35f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V34f0 @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V33g @ V35f ) )
        = ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V33g @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V34f0 @ V35f ) ) )
    & ! [V36g: $o > $o,V37f0: $o > $o,V38f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V37f0 @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V36g @ V38f ) )
        = ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V36g @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V37f0 @ V38f ) ) )
    & ! [V39g: $o > $o,V40f0: $o > $o,V41f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V40f0 @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V39g @ V41f ) )
        = ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V39g @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V40f0 @ V41f ) ) )
    & ! [V42g: $o > $o,V43f0: $o > $o,V44f: tyop_2Ebinary__ieee_2Eflags] :
        ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V43f0 @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V42g @ V44f ) )
        = ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V42g @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V43f0 @ V44f ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__fupdcanon__comp,axiom,
    ! [A_27a: $tType] :
      ( ! [V0g: $o > $o,V1f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V1f0 ) @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V1f0 ) ) )
      & ! [V2h: A_27a > tyop_2Ebinary__ieee_2Eflags,V3g: $o > $o,V4f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V4f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V3g ) @ V2h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V3g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V4f0 ) @ V2h ) ) )
      & ! [V5g: $o > $o,V6f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V6f0 ) @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V5g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V5g ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V6f0 ) ) )
      & ! [V7h: A_27a > tyop_2Ebinary__ieee_2Eflags,V8g: $o > $o,V9f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V9f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V8g ) @ V7h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V8g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V9f0 ) @ V7h ) ) )
      & ! [V10g: $o > $o,V11f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V11f0 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V10g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V10g ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V11f0 ) ) )
      & ! [V12h: A_27a > tyop_2Ebinary__ieee_2Eflags,V13g: $o > $o,V14f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V14f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V13g ) @ V12h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V13g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V14f0 ) @ V12h ) ) )
      & ! [V15g: $o > $o,V16f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V16f0 ) @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V15g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V15g ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V16f0 ) ) )
      & ! [V17h: A_27a > tyop_2Ebinary__ieee_2Eflags,V18g: $o > $o,V19f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V19f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V18g ) @ V17h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V18g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V19f0 ) @ V17h ) ) )
      & ! [V20g: $o > $o,V21f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V21f0 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V20g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V20g ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V21f0 ) ) )
      & ! [V22h: A_27a > tyop_2Ebinary__ieee_2Eflags,V23g: $o > $o,V24f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V24f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V23g ) @ V22h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V23g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V24f0 ) @ V22h ) ) )
      & ! [V25g: $o > $o,V26f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V26f0 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V25g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V25g ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V26f0 ) ) )
      & ! [V27h: A_27a > tyop_2Ebinary__ieee_2Eflags,V28g: $o > $o,V29f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V29f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V28g ) @ V27h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V28g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V29f0 ) @ V27h ) ) )
      & ! [V30g: $o > $o,V31f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V31f0 ) @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V30g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V30g ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V31f0 ) ) )
      & ! [V32h: A_27a > tyop_2Ebinary__ieee_2Eflags,V33g: $o > $o,V34f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V34f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V33g ) @ V32h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V33g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V34f0 ) @ V32h ) ) )
      & ! [V35g: $o > $o,V36f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V36f0 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V35g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V35g ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V36f0 ) ) )
      & ! [V37h: A_27a > tyop_2Ebinary__ieee_2Eflags,V38g: $o > $o,V39f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V39f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V38g ) @ V37h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V38g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V39f0 ) @ V37h ) ) )
      & ! [V40g: $o > $o,V41f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V41f0 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V40g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V40g ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V41f0 ) ) )
      & ! [V42h: A_27a > tyop_2Ebinary__ieee_2Eflags,V43g: $o > $o,V44f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V44f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V43g ) @ V42h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V43g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V44f0 ) @ V42h ) ) )
      & ! [V45g: $o > $o,V46f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V46f0 ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V45g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V45g ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V46f0 ) ) )
      & ! [V47h: A_27a > tyop_2Ebinary__ieee_2Eflags,V48g: $o > $o,V49f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V49f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V48g ) @ V47h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V48g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V49f0 ) @ V47h ) ) )
      & ! [V50g: $o > $o,V51f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V51f0 ) @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V50g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V50g ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V51f0 ) ) )
      & ! [V52h: A_27a > tyop_2Ebinary__ieee_2Eflags,V53g: $o > $o,V54f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V54f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V53g ) @ V52h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V53g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V54f0 ) @ V52h ) ) )
      & ! [V55g: $o > $o,V56f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V56f0 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V55g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V55g ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V56f0 ) ) )
      & ! [V57h: A_27a > tyop_2Ebinary__ieee_2Eflags,V58g: $o > $o,V59f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V59f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V58g ) @ V57h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V58g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V59f0 ) @ V57h ) ) )
      & ! [V60g: $o > $o,V61f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V61f0 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V60g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V60g ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V61f0 ) ) )
      & ! [V62h: A_27a > tyop_2Ebinary__ieee_2Eflags,V63g: $o > $o,V64f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V64f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V63g ) @ V62h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V63g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V64f0 ) @ V62h ) ) )
      & ! [V65g: $o > $o,V66f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V66f0 ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V65g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V65g ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V66f0 ) ) )
      & ! [V67h: A_27a > tyop_2Ebinary__ieee_2Eflags,V68g: $o > $o,V69f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V69f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V68g ) @ V67h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ V68g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V69f0 ) @ V67h ) ) )
      & ! [V70g: $o > $o,V71f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V71f0 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V70g ) )
          = ( c_2Ecombin_2Eo @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V70g ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V71f0 ) ) )
      & ! [V72h: A_27a > tyop_2Ebinary__ieee_2Eflags,V73g: $o > $o,V74f0: $o > $o] :
          ( ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V74f0 ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V73g ) @ V72h ) )
          = ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V73g ) @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Ebinary__ieee_2Eflags @ tyop_2Ebinary__ieee_2Eflags @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V74f0 ) @ V72h ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__component__equality,axiom,
    ! [V0f1: tyop_2Ebinary__ieee_2Eflags,V1f2: tyop_2Ebinary__ieee_2Eflags] :
      ( ( V0f1 = V1f2 )
    <=> ( ( ( c_2Ebinary__ieee_2Eflags__DivideByZero @ V0f1 )
          = ( c_2Ebinary__ieee_2Eflags__DivideByZero @ V1f2 ) )
        & ( ( c_2Ebinary__ieee_2Eflags__InvalidOp @ V0f1 )
          = ( c_2Ebinary__ieee_2Eflags__InvalidOp @ V1f2 ) )
        & ( ( c_2Ebinary__ieee_2Eflags__Overflow @ V0f1 )
          = ( c_2Ebinary__ieee_2Eflags__Overflow @ V1f2 ) )
        & ( ( c_2Ebinary__ieee_2Eflags__Precision @ V0f1 )
          = ( c_2Ebinary__ieee_2Eflags__Precision @ V1f2 ) )
        & ( ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ V0f1 )
          = ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ V1f2 ) )
        & ( ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ V0f1 )
          = ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ V1f2 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__updates__eq__literal,axiom,
    ! [V0f: tyop_2Ebinary__ieee_2Eflags,V1b4: $o,V2b3: $o,V3b2: $o,V4b1: $o,V5b0: $o,V6b: $o] :
      ( ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V1b4 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V2b3 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V3b2 ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V4b1 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V5b0 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V6b ) @ V0f ) ) ) ) ) )
      = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V1b4 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V2b3 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V3b2 ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V4b1 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V5b0 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V6b ) @ ( c_2Ebool_2EARB @ tyop_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__literal__nchotomy,axiom,
    ! [V0f: tyop_2Ebinary__ieee_2Eflags] :
    ? [V1b4: $o,V2b3: $o,V3b2: $o,V4b1: $o,V5b0: $o,V6b: $o] :
      ( V0f
      = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V1b4 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V2b3 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V3b2 ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V4b1 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V5b0 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V6b ) @ ( c_2Ebool_2EARB @ tyop_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2EFORALL__flags,axiom,
    ! [V0P: tyop_2Ebinary__ieee_2Eflags > $o] :
      ( ! [V1f: tyop_2Ebinary__ieee_2Eflags] : ( V0P @ V1f )
    <=> ! [V2b4: $o,V3b3: $o,V4b2: $o,V5b1: $o,V6b0: $o,V7b: $o] : ( V0P @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V2b4 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V3b3 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V4b2 ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V5b1 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V6b0 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V7b ) @ ( c_2Ebool_2EARB @ tyop_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2EEXISTS__flags,axiom,
    ! [V0P: tyop_2Ebinary__ieee_2Eflags > $o] :
      ( ? [V1f: tyop_2Ebinary__ieee_2Eflags] : ( V0P @ V1f )
    <=> ? [V2b4: $o,V3b3: $o,V4b2: $o,V5b1: $o,V6b0: $o,V7b: $o] : ( V0P @ ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V2b4 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V3b3 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V4b2 ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V5b1 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V6b0 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V7b ) @ ( c_2Ebool_2EARB @ tyop_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__literal__11,axiom,
    ! [V0b41: $o,V1b31: $o,V2b21: $o,V3b11: $o,V4b01: $o,V5b1: $o,V6b42: $o,V7b32: $o,V8b22: $o,V9b12: $o,V10b02: $o,V11b2: $o] :
      ( ( ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V0b41 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V1b31 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V2b21 ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V3b11 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V4b01 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V5b1 ) @ ( c_2Ebool_2EARB @ tyop_2Ebinary__ieee_2Eflags ) ) ) ) ) ) )
        = ( c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V6b42 ) @ ( c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V7b32 ) @ ( c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V8b22 ) @ ( c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V9b12 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V10b02 ) @ ( c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( c_2Ecombin_2EK @ $o @ $o @ V11b2 ) @ ( c_2Ebool_2EARB @ tyop_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) )
    <=> ( ( V0b41 = V6b42 )
        & ( V1b31 = V7b32 )
        & ( V2b21 = V8b22 )
        & ( V3b11 = V9b12 )
        & ( V4b01 = V10b02 )
        & ( V5b1 = V11b2 ) ) ) ).

thf(thm_2Ebinary__ieee_2Edatatype__flags,axiom,
    ! [V0record: tyop_2Ebinary__ieee_2Eflags > $o > $o > $o > $o > $o > $o > $o,V1flags: tyop_2Ebinary__ieee_2Eflags,V2Underflow__BeforeRounding: $o,V3Underflow__AfterRounding: $o,V4Precision: $o,V5Overflow: $o,V6InvalidOp: $o,V7DivideByZero: $o] : ( c_2Ebool_2EDATATYPE @ $o @ ( V0record @ V1flags @ V7DivideByZero @ V6InvalidOp @ V5Overflow @ V4Precision @ V2Underflow__BeforeRounding @ V3Underflow__AfterRounding ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__11,axiom,
    ! [V0a0: $o,V1a1: $o,V2a2: $o,V3a3: $o,V4a4: $o,V5a5: $o,V6a0_27: $o,V7a1_27: $o,V8a2_27: $o,V9a3_27: $o,V10a4_27: $o,V11a5_27: $o] :
      ( ( ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0a0 @ V1a1 @ V2a2 @ V3a3 @ V4a4 @ V5a5 )
        = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V6a0_27 @ V7a1_27 @ V8a2_27 @ V9a3_27 @ V10a4_27 @ V11a5_27 ) )
    <=> ( ( V0a0 = V6a0_27 )
        & ( V1a1 = V7a1_27 )
        & ( V2a2 = V8a2_27 )
        & ( V3a3 = V9a3_27 )
        & ( V4a4 = V10a4_27 )
        & ( V5a5 = V11a5_27 ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__nchotomy,axiom,
    ! [V0ff: tyop_2Ebinary__ieee_2Eflags] :
    ? [V1b: $o,V2b0: $o,V3b1: $o,V4b2: $o,V5b3: $o,V6b4: $o] :
      ( V0ff
      = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__Axiom,axiom,
    ! [A_27a: $tType,V0f: $o > $o > $o > $o > $o > $o > A_27a] :
    ? [V1fn: tyop_2Ebinary__ieee_2Eflags > A_27a] :
    ! [V2a0: $o,V3a1: $o,V4a2: $o,V5a3: $o,V6a4: $o,V7a5: $o] :
      ( ( V1fn @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V2a0 @ V3a1 @ V4a2 @ V5a3 @ V6a4 @ V7a5 ) )
      = ( V0f @ V2a0 @ V3a1 @ V4a2 @ V5a3 @ V6a4 @ V7a5 ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__induction,axiom,
    ! [V0P: tyop_2Ebinary__ieee_2Eflags > $o] :
      ( ! [V1b: $o,V2b0: $o,V3b1: $o,V4b2: $o,V5b3: $o,V6b4: $o] : ( V0P @ ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b @ V2b0 @ V3b1 @ V4b2 @ V5b3 @ V6b4 ) )
     => ! [V7f: tyop_2Ebinary__ieee_2Eflags] : ( V0P @ V7f ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__case__cong,axiom,
    ! [A_27a: $tType,V0f_27: $o > $o > $o > $o > $o > $o > A_27a,V1M: tyop_2Ebinary__ieee_2Eflags,V2M_27: tyop_2Ebinary__ieee_2Eflags,V3f: $o > $o > $o > $o > $o > $o > A_27a] :
      ( ( ( V1M = V2M_27 )
        & ! [V4a0: $o,V5a1: $o,V6a2: $o,V7a3: $o,V8a4: $o,V9a5: $o] :
            ( ( V2M_27
              = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V4a0 @ V5a1 @ V6a2 @ V7a3 @ V8a4 @ V9a5 ) )
           => ( ( V3f @ V4a0 @ V5a1 @ V6a2 @ V7a3 @ V8a4 @ V9a5 )
              = ( V0f_27 @ V4a0 @ V5a1 @ V6a2 @ V7a3 @ V8a4 @ V9a5 ) ) ) )
     => ( ( c_2Ebinary__ieee_2Eflags__CASE @ A_27a @ V1M @ V3f )
        = ( c_2Ebinary__ieee_2Eflags__CASE @ A_27a @ V2M_27 @ V0f_27 ) ) ) ).

thf(thm_2Ebinary__ieee_2Eflags__case__eq,axiom,
    ! [A_27a: $tType,V0x: tyop_2Ebinary__ieee_2Eflags,V1v: A_27a,V2f: $o > $o > $o > $o > $o > $o > A_27a] :
      ( ( ( c_2Ebinary__ieee_2Eflags__CASE @ A_27a @ V0x @ V2f )
        = V1v )
    <=> ? [V3b: $o,V4b0: $o,V5b1: $o,V6b2: $o,V7b3: $o,V8b4: $o] :
          ( ( V0x
            = ( c_2Ebinary__ieee_2Erecordtype_2Eflags @ V3b @ V4b0 @ V5b1 @ V6b2 @ V7b3 @ V8b4 ) )
          & ( ( V2f @ V3b @ V4b0 @ V5b1 @ V6b2 @ V7b3 @ V8b4 )
            = V1v ) ) ) ).

thf(thm_2Ebinary__ieee_2Enum2rounding__rounding2num,axiom,
    ! [V0a: tyop_2Ebinary__ieee_2Erounding] :
      ( ( c_2Ebinary__ieee_2Enum2rounding @ ( c_2Ebinary__ieee_2Erounding2num @ V0a ) )
      = V0a ) ).

thf(thm_2Ebinary__ieee_2Erounding2num__num2rounding,axiom,
    ! [V0r: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0r @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
    <=> ( ( c_2Ebinary__ieee_2Erounding2num @ ( c_2Ebinary__ieee_2Enum2rounding @ V0r ) )
        = V0r ) ) ).

thf(thm_2Ebinary__ieee_2Enum2rounding__11,axiom,
    ! [V0r: tyop_2Enum_2Enum,V1r_27: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0r @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
     => ( ( c_2Eprim__rec_2E_3C @ V1r_27 @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
       => ( ( ( c_2Ebinary__ieee_2Enum2rounding @ V0r )
            = ( c_2Ebinary__ieee_2Enum2rounding @ V1r_27 ) )
        <=> ( V0r = V1r_27 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Erounding2num__11,axiom,
    ! [V0a: tyop_2Ebinary__ieee_2Erounding,V1a_27: tyop_2Ebinary__ieee_2Erounding] :
      ( ( ( c_2Ebinary__ieee_2Erounding2num @ V0a )
        = ( c_2Ebinary__ieee_2Erounding2num @ V1a_27 ) )
    <=> ( V0a = V1a_27 ) ) ).

thf(thm_2Ebinary__ieee_2Enum2rounding__ONTO,axiom,
    ! [V0a: tyop_2Ebinary__ieee_2Erounding] :
    ? [V1r: tyop_2Enum_2Enum] :
      ( ( V0a
        = ( c_2Ebinary__ieee_2Enum2rounding @ V1r ) )
      & ( c_2Eprim__rec_2E_3C @ V1r @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Erounding2num__ONTO,axiom,
    ! [V0r: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0r @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
    <=> ? [V1a: tyop_2Ebinary__ieee_2Erounding] :
          ( V0r
          = ( c_2Ebinary__ieee_2Erounding2num @ V1a ) ) ) ).

thf(thm_2Ebinary__ieee_2Enum2rounding__thm,axiom,
    ( ( ( c_2Ebinary__ieee_2Enum2rounding @ c_2Enum_2E0 )
      = c_2Ebinary__ieee_2EroundTiesToEven )
    & ( ( c_2Ebinary__ieee_2Enum2rounding @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
      = c_2Ebinary__ieee_2EroundTowardPositive )
    & ( ( c_2Ebinary__ieee_2Enum2rounding @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) )
      = c_2Ebinary__ieee_2EroundTowardNegative )
    & ( ( c_2Ebinary__ieee_2Enum2rounding @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      = c_2Ebinary__ieee_2EroundTowardZero ) ) ).

thf(thm_2Ebinary__ieee_2Erounding2num__thm,axiom,
    ( ( ( c_2Ebinary__ieee_2Erounding2num @ c_2Ebinary__ieee_2EroundTiesToEven )
      = c_2Enum_2E0 )
    & ( ( c_2Ebinary__ieee_2Erounding2num @ c_2Ebinary__ieee_2EroundTowardPositive )
      = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
    & ( ( c_2Ebinary__ieee_2Erounding2num @ c_2Ebinary__ieee_2EroundTowardNegative )
      = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) )
    & ( ( c_2Ebinary__ieee_2Erounding2num @ c_2Ebinary__ieee_2EroundTowardZero )
      = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Erounding__EQ__rounding,axiom,
    ! [V0a: tyop_2Ebinary__ieee_2Erounding,V1a_27: tyop_2Ebinary__ieee_2Erounding] :
      ( ( V0a = V1a_27 )
    <=> ( ( c_2Ebinary__ieee_2Erounding2num @ V0a )
        = ( c_2Ebinary__ieee_2Erounding2num @ V1a_27 ) ) ) ).

thf(thm_2Ebinary__ieee_2Erounding__case__def,axiom,
    ! [A_27a: $tType] :
      ( ! [V0v0: A_27a,V1v1: A_27a,V2v2: A_27a,V3v3: A_27a] :
          ( ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a @ c_2Ebinary__ieee_2EroundTiesToEven @ V0v0 @ V1v1 @ V2v2 @ V3v3 )
          = V0v0 )
      & ! [V4v0: A_27a,V5v1: A_27a,V6v2: A_27a,V7v3: A_27a] :
          ( ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a @ c_2Ebinary__ieee_2EroundTowardPositive @ V4v0 @ V5v1 @ V6v2 @ V7v3 )
          = V5v1 )
      & ! [V8v0: A_27a,V9v1: A_27a,V10v2: A_27a,V11v3: A_27a] :
          ( ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a @ c_2Ebinary__ieee_2EroundTowardNegative @ V8v0 @ V9v1 @ V10v2 @ V11v3 )
          = V10v2 )
      & ! [V12v0: A_27a,V13v1: A_27a,V14v2: A_27a,V15v3: A_27a] :
          ( ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a @ c_2Ebinary__ieee_2EroundTowardZero @ V12v0 @ V13v1 @ V14v2 @ V15v3 )
          = V15v3 ) ) ).

thf(thm_2Ebinary__ieee_2Edatatype__rounding,axiom,
    ! [V0rounding: tyop_2Ebinary__ieee_2Erounding > tyop_2Ebinary__ieee_2Erounding > tyop_2Ebinary__ieee_2Erounding > tyop_2Ebinary__ieee_2Erounding > $o] : ( c_2Ebool_2EDATATYPE @ $o @ ( V0rounding @ c_2Ebinary__ieee_2EroundTiesToEven @ c_2Ebinary__ieee_2EroundTowardPositive @ c_2Ebinary__ieee_2EroundTowardNegative @ c_2Ebinary__ieee_2EroundTowardZero ) ) ).

thf(thm_2Ebinary__ieee_2Erounding__distinct,axiom,
    ( ( (~) @ ( c_2Ebinary__ieee_2EroundTiesToEven = c_2Ebinary__ieee_2EroundTowardPositive ) )
    & ( (~) @ ( c_2Ebinary__ieee_2EroundTiesToEven = c_2Ebinary__ieee_2EroundTowardNegative ) )
    & ( (~) @ ( c_2Ebinary__ieee_2EroundTiesToEven = c_2Ebinary__ieee_2EroundTowardZero ) )
    & ( (~) @ ( c_2Ebinary__ieee_2EroundTowardPositive = c_2Ebinary__ieee_2EroundTowardNegative ) )
    & ( (~) @ ( c_2Ebinary__ieee_2EroundTowardPositive = c_2Ebinary__ieee_2EroundTowardZero ) )
    & ( (~) @ ( c_2Ebinary__ieee_2EroundTowardNegative = c_2Ebinary__ieee_2EroundTowardZero ) ) ) ).

thf(thm_2Ebinary__ieee_2Erounding__nchotomy,axiom,
    ! [V0a: tyop_2Ebinary__ieee_2Erounding] :
      ( ( V0a = c_2Ebinary__ieee_2EroundTiesToEven )
      | ( V0a = c_2Ebinary__ieee_2EroundTowardPositive )
      | ( V0a = c_2Ebinary__ieee_2EroundTowardNegative )
      | ( V0a = c_2Ebinary__ieee_2EroundTowardZero ) ) ).

thf(thm_2Ebinary__ieee_2Erounding__Axiom,axiom,
    ! [A_27a: $tType,V0x0: A_27a,V1x1: A_27a,V2x2: A_27a,V3x3: A_27a] :
    ? [V4f: tyop_2Ebinary__ieee_2Erounding > A_27a] :
      ( ( ( V4f @ c_2Ebinary__ieee_2EroundTiesToEven )
        = V0x0 )
      & ( ( V4f @ c_2Ebinary__ieee_2EroundTowardPositive )
        = V1x1 )
      & ( ( V4f @ c_2Ebinary__ieee_2EroundTowardNegative )
        = V2x2 )
      & ( ( V4f @ c_2Ebinary__ieee_2EroundTowardZero )
        = V3x3 ) ) ).

thf(thm_2Ebinary__ieee_2Erounding__induction,axiom,
    ! [V0P: tyop_2Ebinary__ieee_2Erounding > $o] :
      ( ( ( V0P @ c_2Ebinary__ieee_2EroundTiesToEven )
        & ( V0P @ c_2Ebinary__ieee_2EroundTowardNegative )
        & ( V0P @ c_2Ebinary__ieee_2EroundTowardPositive )
        & ( V0P @ c_2Ebinary__ieee_2EroundTowardZero ) )
     => ! [V1a: tyop_2Ebinary__ieee_2Erounding] : ( V0P @ V1a ) ) ).

thf(thm_2Ebinary__ieee_2Erounding__case__cong,axiom,
    ! [A_27a: $tType,V0v3_27: A_27a,V1v2_27: A_27a,V2v1_27: A_27a,V3v0_27: A_27a,V4M: tyop_2Ebinary__ieee_2Erounding,V5M_27: tyop_2Ebinary__ieee_2Erounding,V6v0: A_27a,V7v1: A_27a,V8v2: A_27a,V9v3: A_27a] :
      ( ( ( V4M = V5M_27 )
        & ( ( V5M_27 = c_2Ebinary__ieee_2EroundTiesToEven )
         => ( V6v0 = V3v0_27 ) )
        & ( ( V5M_27 = c_2Ebinary__ieee_2EroundTowardPositive )
         => ( V7v1 = V2v1_27 ) )
        & ( ( V5M_27 = c_2Ebinary__ieee_2EroundTowardNegative )
         => ( V8v2 = V1v2_27 ) )
        & ( ( V5M_27 = c_2Ebinary__ieee_2EroundTowardZero )
         => ( V9v3 = V0v3_27 ) ) )
     => ( ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a @ V4M @ V6v0 @ V7v1 @ V8v2 @ V9v3 )
        = ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a @ V5M_27 @ V3v0_27 @ V2v1_27 @ V1v2_27 @ V0v3_27 ) ) ) ).

thf(thm_2Ebinary__ieee_2Erounding__case__eq,axiom,
    ! [A_27a: $tType,V0x: tyop_2Ebinary__ieee_2Erounding,V1v3: A_27a,V2v2: A_27a,V3v1: A_27a,V4v0: A_27a,V5v: A_27a] :
      ( ( ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a @ V0x @ V4v0 @ V3v1 @ V2v2 @ V1v3 )
        = V5v )
    <=> ( ( ( V0x = c_2Ebinary__ieee_2EroundTiesToEven )
          & ( V4v0 = V5v ) )
        | ( ( V0x = c_2Ebinary__ieee_2EroundTowardPositive )
          & ( V3v1 = V5v ) )
        | ( ( V0x = c_2Ebinary__ieee_2EroundTowardNegative )
          & ( V2v2 = V5v ) )
        | ( ( V0x = c_2Ebinary__ieee_2EroundTowardZero )
          & ( V1v3 = V5v ) ) ) ) ).

thf(thm_2Ebinary__ieee_2EULP__ind,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0P: ( tyop_2Epair_2Eprod @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) ) > $o] :
      ( ! [V1e: tyop_2Efcp_2Ecart @ $o @ A_27w] : ( V0P @ ( c_2Epair_2E_2C @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) @ V1e @ ( c_2Ebool_2Ethe__value @ A_27t ) ) )
     => ! [V2v: tyop_2Efcp_2Ecart @ $o @ A_27w,V3v1: tyop_2Ebool_2Eitself @ A_27t] : ( V0P @ ( c_2Epair_2E_2C @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) @ V2v @ V3v1 ) ) ) ).

thf(thm_2Ebinary__ieee_2EULP__def,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0e: tyop_2Efcp_2Ecart @ $o @ A_27w] :
      ( ( c_2Ebinary__ieee_2EULP @ A_27t @ A_27w @ ( c_2Epair_2E_2C @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ ( tyop_2Ebool_2Eitself @ A_27t ) @ V0e @ ( c_2Ebool_2Ethe__value @ A_27t ) ) )
      = ( c_2Ereal_2E_2F @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ebool_2ECOND @ tyop_2Enum_2Enum @ ( c_2Emin_2E_3D @ ( tyop_2Efcp_2Ecart @ $o @ A_27w ) @ V0e @ ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Ewords_2Ew2n @ A_27w @ V0e ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ewords_2EINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) @ ( c_2Efcp_2Edimindex @ A_27t @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Edatatype__fp__op,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0fp__op: ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) > ( tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) > $o] : ( c_2Ebool_2EDATATYPE @ $o @ ( V0fp__op @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) ) ) ).

thf(thm_2Ebinary__ieee_2Efp__op__11,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ! [V0a0: tyop_2Ebinary__ieee_2Erounding,V1a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2a0_27: tyop_2Ebinary__ieee_2Erounding,V3a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V0a0 @ V1a1 )
            = ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V2a0_27 @ V3a1_27 ) )
        <=> ( ( V0a0 = V2a0_27 )
            & ( V1a1 = V3a1_27 ) ) )
      & ! [V4a0: tyop_2Ebinary__ieee_2Erounding,V5a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V6a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V7a0_27: tyop_2Ebinary__ieee_2Erounding,V8a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V9a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V4a0 @ V5a1 @ V6a2 )
            = ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V7a0_27 @ V8a1_27 @ V9a2_27 ) )
        <=> ( ( V4a0 = V7a0_27 )
            & ( V5a1 = V8a1_27 )
            & ( V6a2 = V9a2_27 ) ) )
      & ! [V10a0: tyop_2Ebinary__ieee_2Erounding,V11a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V12a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V13a0_27: tyop_2Ebinary__ieee_2Erounding,V14a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V15a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V10a0 @ V11a1 @ V12a2 )
            = ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V13a0_27 @ V14a1_27 @ V15a2_27 ) )
        <=> ( ( V10a0 = V13a0_27 )
            & ( V11a1 = V14a1_27 )
            & ( V12a2 = V15a2_27 ) ) )
      & ! [V16a0: tyop_2Ebinary__ieee_2Erounding,V17a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V18a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V19a0_27: tyop_2Ebinary__ieee_2Erounding,V20a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V21a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V16a0 @ V17a1 @ V18a2 )
            = ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V19a0_27 @ V20a1_27 @ V21a2_27 ) )
        <=> ( ( V16a0 = V19a0_27 )
            & ( V17a1 = V20a1_27 )
            & ( V18a2 = V21a2_27 ) ) )
      & ! [V22a0: tyop_2Ebinary__ieee_2Erounding,V23a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V24a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V25a0_27: tyop_2Ebinary__ieee_2Erounding,V26a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V27a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V22a0 @ V23a1 @ V24a2 )
            = ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V25a0_27 @ V26a1_27 @ V27a2_27 ) )
        <=> ( ( V22a0 = V25a0_27 )
            & ( V23a1 = V26a1_27 )
            & ( V24a2 = V27a2_27 ) ) )
      & ! [V28a0: tyop_2Ebinary__ieee_2Erounding,V29a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V30a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V31a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V32a0_27: tyop_2Ebinary__ieee_2Erounding,V33a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V34a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V35a3_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V28a0 @ V29a1 @ V30a2 @ V31a3 )
            = ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V32a0_27 @ V33a1_27 @ V34a2_27 @ V35a3_27 ) )
        <=> ( ( V28a0 = V32a0_27 )
            & ( V29a1 = V33a1_27 )
            & ( V30a2 = V34a2_27 )
            & ( V31a3 = V35a3_27 ) ) )
      & ! [V36a0: tyop_2Ebinary__ieee_2Erounding,V37a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V38a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V39a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V40a0_27: tyop_2Ebinary__ieee_2Erounding,V41a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V42a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V43a3_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V36a0 @ V37a1 @ V38a2 @ V39a3 )
            = ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V40a0_27 @ V41a1_27 @ V42a2_27 @ V43a3_27 ) )
        <=> ( ( V36a0 = V40a0_27 )
            & ( V37a1 = V41a1_27 )
            & ( V38a2 = V42a2_27 )
            & ( V39a3 = V43a3_27 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efp__op__distinct,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ! [V0a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V1a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V2a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V3a0_27: tyop_2Ebinary__ieee_2Erounding,V4a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V4a0 @ V2a1 )
            = ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V3a0_27 @ V1a1_27 @ V0a2 ) ) )
      & ! [V5a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V6a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V7a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V8a0_27: tyop_2Ebinary__ieee_2Erounding,V9a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V9a0 @ V7a1 )
            = ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V8a0_27 @ V6a1_27 @ V5a2 ) ) )
      & ! [V10a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V11a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V12a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V13a0_27: tyop_2Ebinary__ieee_2Erounding,V14a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V14a0 @ V12a1 )
            = ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V13a0_27 @ V11a1_27 @ V10a2 ) ) )
      & ! [V15a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V16a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V17a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V18a0_27: tyop_2Ebinary__ieee_2Erounding,V19a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V19a0 @ V17a1 )
            = ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V18a0_27 @ V16a1_27 @ V15a2 ) ) )
      & ! [V20a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V21a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V22a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V23a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V24a0_27: tyop_2Ebinary__ieee_2Erounding,V25a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V25a0 @ V23a1 )
            = ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V24a0_27 @ V22a1_27 @ V21a2 @ V20a3 ) ) )
      & ! [V26a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V27a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V28a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V29a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V30a0_27: tyop_2Ebinary__ieee_2Erounding,V31a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V31a0 @ V29a1 )
            = ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V30a0_27 @ V28a1_27 @ V27a2 @ V26a3 ) ) )
      & ! [V32a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V33a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V34a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V35a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V36a0_27: tyop_2Ebinary__ieee_2Erounding,V37a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V37a0 @ V35a1 @ V33a2 )
            = ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V36a0_27 @ V34a1_27 @ V32a2_27 ) ) )
      & ! [V38a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V39a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V40a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V41a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V42a0_27: tyop_2Ebinary__ieee_2Erounding,V43a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V43a0 @ V41a1 @ V39a2 )
            = ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V42a0_27 @ V40a1_27 @ V38a2_27 ) ) )
      & ! [V44a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V45a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V46a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V47a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V48a0_27: tyop_2Ebinary__ieee_2Erounding,V49a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V49a0 @ V47a1 @ V45a2 )
            = ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V48a0_27 @ V46a1_27 @ V44a2_27 ) ) )
      & ! [V50a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V51a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V52a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V53a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V54a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V55a0_27: tyop_2Ebinary__ieee_2Erounding,V56a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V56a0 @ V54a1 @ V52a2 )
            = ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V55a0_27 @ V53a1_27 @ V51a2_27 @ V50a3 ) ) )
      & ! [V57a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V58a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V59a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V60a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V61a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V62a0_27: tyop_2Ebinary__ieee_2Erounding,V63a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V63a0 @ V61a1 @ V59a2 )
            = ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V62a0_27 @ V60a1_27 @ V58a2_27 @ V57a3 ) ) )
      & ! [V64a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V65a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V66a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V67a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V68a0_27: tyop_2Ebinary__ieee_2Erounding,V69a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V69a0 @ V67a1 @ V65a2 )
            = ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V68a0_27 @ V66a1_27 @ V64a2_27 ) ) )
      & ! [V70a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V71a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V72a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V73a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V74a0_27: tyop_2Ebinary__ieee_2Erounding,V75a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V75a0 @ V73a1 @ V71a2 )
            = ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V74a0_27 @ V72a1_27 @ V70a2_27 ) ) )
      & ! [V76a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V77a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V78a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V79a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V80a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V81a0_27: tyop_2Ebinary__ieee_2Erounding,V82a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V82a0 @ V80a1 @ V78a2 )
            = ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V81a0_27 @ V79a1_27 @ V77a2_27 @ V76a3 ) ) )
      & ! [V83a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V84a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V85a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V86a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V87a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V88a0_27: tyop_2Ebinary__ieee_2Erounding,V89a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V89a0 @ V87a1 @ V85a2 )
            = ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V88a0_27 @ V86a1_27 @ V84a2_27 @ V83a3 ) ) )
      & ! [V90a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V91a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V92a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V93a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V94a0_27: tyop_2Ebinary__ieee_2Erounding,V95a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V95a0 @ V93a1 @ V91a2 )
            = ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V94a0_27 @ V92a1_27 @ V90a2_27 ) ) )
      & ! [V96a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V97a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V98a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V99a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V100a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V101a0_27: tyop_2Ebinary__ieee_2Erounding,V102a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V102a0 @ V100a1 @ V98a2 )
            = ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V101a0_27 @ V99a1_27 @ V97a2_27 @ V96a3 ) ) )
      & ! [V103a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V104a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V105a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V106a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V107a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V108a0_27: tyop_2Ebinary__ieee_2Erounding,V109a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V109a0 @ V107a1 @ V105a2 )
            = ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V108a0_27 @ V106a1_27 @ V104a2_27 @ V103a3 ) ) )
      & ! [V110a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V111a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V112a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V113a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V114a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V115a0_27: tyop_2Ebinary__ieee_2Erounding,V116a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V116a0 @ V114a1 @ V112a2 )
            = ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V115a0_27 @ V113a1_27 @ V111a2_27 @ V110a3 ) ) )
      & ! [V117a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V118a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V119a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V120a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V121a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V122a0_27: tyop_2Ebinary__ieee_2Erounding,V123a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V123a0 @ V121a1 @ V119a2 )
            = ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V122a0_27 @ V120a1_27 @ V118a2_27 @ V117a3 ) ) )
      & ! [V124a3_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V125a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V126a2_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V127a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V128a1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V129a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V130a0_27: tyop_2Ebinary__ieee_2Erounding,V131a0: tyop_2Ebinary__ieee_2Erounding] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V131a0 @ V129a1 @ V127a2 @ V125a3 )
            = ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V130a0_27 @ V128a1_27 @ V126a2_27 @ V124a3_27 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efp__op__nchotomy,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0ff: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] :
      ( ? [V1r: tyop_2Ebinary__ieee_2Erounding,V2f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( V0ff
          = ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V1r @ V2f ) )
      | ? [V3r: tyop_2Ebinary__ieee_2Erounding,V4f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V5f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( V0ff
          = ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V3r @ V4f @ V5f0 ) )
      | ? [V6r: tyop_2Ebinary__ieee_2Erounding,V7f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V8f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( V0ff
          = ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V6r @ V7f @ V8f0 ) )
      | ? [V9r: tyop_2Ebinary__ieee_2Erounding,V10f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V11f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( V0ff
          = ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V9r @ V10f @ V11f0 ) )
      | ? [V12r: tyop_2Ebinary__ieee_2Erounding,V13f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V14f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( V0ff
          = ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V12r @ V13f @ V14f0 ) )
      | ? [V15r: tyop_2Ebinary__ieee_2Erounding,V16f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V17f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V18f1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( V0ff
          = ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V15r @ V16f @ V17f0 @ V18f1 ) )
      | ? [V19r: tyop_2Ebinary__ieee_2Erounding,V20f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V21f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V22f1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( V0ff
          = ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V19r @ V20f @ V21f0 @ V22f1 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efp__op__Axiom,axiom,
    ! [A_27a: $tType,A_27t: $tType,A_27w: $tType,V0f0: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V1f1: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V2f2: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V3f3: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V4f4: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V5f5: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V6f6: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
    ? [V7fn: ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) > A_27a] :
      ( ! [V8a0: tyop_2Ebinary__ieee_2Erounding,V9a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( V7fn @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V8a0 @ V9a1 ) )
          = ( V0f0 @ V8a0 @ V9a1 ) )
      & ! [V10a0: tyop_2Ebinary__ieee_2Erounding,V11a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V12a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( V7fn @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V10a0 @ V11a1 @ V12a2 ) )
          = ( V1f1 @ V10a0 @ V11a1 @ V12a2 ) )
      & ! [V13a0: tyop_2Ebinary__ieee_2Erounding,V14a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V15a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( V7fn @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V13a0 @ V14a1 @ V15a2 ) )
          = ( V2f2 @ V13a0 @ V14a1 @ V15a2 ) )
      & ! [V16a0: tyop_2Ebinary__ieee_2Erounding,V17a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V18a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( V7fn @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V16a0 @ V17a1 @ V18a2 ) )
          = ( V3f3 @ V16a0 @ V17a1 @ V18a2 ) )
      & ! [V19a0: tyop_2Ebinary__ieee_2Erounding,V20a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V21a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( V7fn @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V19a0 @ V20a1 @ V21a2 ) )
          = ( V4f4 @ V19a0 @ V20a1 @ V21a2 ) )
      & ! [V22a0: tyop_2Ebinary__ieee_2Erounding,V23a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V24a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V25a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( V7fn @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V22a0 @ V23a1 @ V24a2 @ V25a3 ) )
          = ( V5f5 @ V22a0 @ V23a1 @ V24a2 @ V25a3 ) )
      & ! [V26a0: tyop_2Ebinary__ieee_2Erounding,V27a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V28a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V29a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
          ( ( V7fn @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V26a0 @ V27a1 @ V28a2 @ V29a3 ) )
          = ( V6f6 @ V26a0 @ V27a1 @ V28a2 @ V29a3 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efp__op__induction,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0P: ( tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) > $o] :
      ( ( ! [V1r: tyop_2Ebinary__ieee_2Erounding,V2f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( V0P @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V1r @ V2f ) )
        & ! [V3r: tyop_2Ebinary__ieee_2Erounding,V4f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V5f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( V0P @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V3r @ V4f @ V5f0 ) )
        & ! [V6r: tyop_2Ebinary__ieee_2Erounding,V7f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V8f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( V0P @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V6r @ V7f @ V8f0 ) )
        & ! [V9r: tyop_2Ebinary__ieee_2Erounding,V10f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V11f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( V0P @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V9r @ V10f @ V11f0 ) )
        & ! [V12r: tyop_2Ebinary__ieee_2Erounding,V13f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V14f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( V0P @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V12r @ V13f @ V14f0 ) )
        & ! [V15r: tyop_2Ebinary__ieee_2Erounding,V16f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V17f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V18f1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( V0P @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V15r @ V16f @ V17f0 @ V18f1 ) )
        & ! [V19r: tyop_2Ebinary__ieee_2Erounding,V20f: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V21f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V22f1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] : ( V0P @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V19r @ V20f @ V21f0 @ V22f1 ) ) )
     => ! [V23f: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] : ( V0P @ V23f ) ) ).

thf(thm_2Ebinary__ieee_2Efp__op__case__cong,axiom,
    ! [A_27a: $tType,A_27t: $tType,A_27w: $tType,V0f6_27: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V1f5_27: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V2f4_27: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V3f3_27: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V4f2_27: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V5f1_27: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V6f_27: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V7M: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w,V8M_27: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w,V9f: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V10f1: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V11f2: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V12f3: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V13f4: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V14f5: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V15f6: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
      ( ( ( V7M = V8M_27 )
        & ! [V16a0: tyop_2Ebinary__ieee_2Erounding,V17a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V8M_27
              = ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V16a0 @ V17a1 ) )
           => ( ( V9f @ V16a0 @ V17a1 )
              = ( V6f_27 @ V16a0 @ V17a1 ) ) )
        & ! [V18a0: tyop_2Ebinary__ieee_2Erounding,V19a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V20a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V8M_27
              = ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V18a0 @ V19a1 @ V20a2 ) )
           => ( ( V10f1 @ V18a0 @ V19a1 @ V20a2 )
              = ( V5f1_27 @ V18a0 @ V19a1 @ V20a2 ) ) )
        & ! [V21a0: tyop_2Ebinary__ieee_2Erounding,V22a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V23a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V8M_27
              = ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V21a0 @ V22a1 @ V23a2 ) )
           => ( ( V11f2 @ V21a0 @ V22a1 @ V23a2 )
              = ( V4f2_27 @ V21a0 @ V22a1 @ V23a2 ) ) )
        & ! [V24a0: tyop_2Ebinary__ieee_2Erounding,V25a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V26a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V8M_27
              = ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V24a0 @ V25a1 @ V26a2 ) )
           => ( ( V12f3 @ V24a0 @ V25a1 @ V26a2 )
              = ( V3f3_27 @ V24a0 @ V25a1 @ V26a2 ) ) )
        & ! [V27a0: tyop_2Ebinary__ieee_2Erounding,V28a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V29a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V8M_27
              = ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V27a0 @ V28a1 @ V29a2 ) )
           => ( ( V13f4 @ V27a0 @ V28a1 @ V29a2 )
              = ( V2f4_27 @ V27a0 @ V28a1 @ V29a2 ) ) )
        & ! [V30a0: tyop_2Ebinary__ieee_2Erounding,V31a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V32a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V33a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V8M_27
              = ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V30a0 @ V31a1 @ V32a2 @ V33a3 ) )
           => ( ( V14f5 @ V30a0 @ V31a1 @ V32a2 @ V33a3 )
              = ( V1f5_27 @ V30a0 @ V31a1 @ V32a2 @ V33a3 ) ) )
        & ! [V34a0: tyop_2Ebinary__ieee_2Erounding,V35a1: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V36a2: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V37a3: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V8M_27
              = ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V34a0 @ V35a1 @ V36a2 @ V37a3 ) )
           => ( ( V15f6 @ V34a0 @ V35a1 @ V36a2 @ V37a3 )
              = ( V0f6_27 @ V34a0 @ V35a1 @ V36a2 @ V37a3 ) ) ) )
     => ( ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w @ V7M @ V9f @ V10f1 @ V11f2 @ V12f3 @ V13f4 @ V14f5 @ V15f6 )
        = ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w @ V8M_27 @ V6f_27 @ V5f1_27 @ V4f2_27 @ V3f3_27 @ V2f4_27 @ V1f5_27 @ V0f6_27 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efp__op__case__eq,axiom,
    ! [A_27a: $tType,A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w,V1v: A_27a,V2f6: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V3f5: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V4f4: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V5f3: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V6f2: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V7f1: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a,V8f: tyop_2Ebinary__ieee_2Erounding > ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) > A_27a] :
      ( ( ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w @ V0x @ V8f @ V7f1 @ V6f2 @ V5f3 @ V4f4 @ V3f5 @ V2f6 )
        = V1v )
    <=> ( ? [V9r: tyop_2Ebinary__ieee_2Erounding,V10f_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V0x
              = ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w @ V9r @ V10f_27 ) )
            & ( ( V8f @ V9r @ V10f_27 )
              = V1v ) )
        | ? [V11r: tyop_2Ebinary__ieee_2Erounding,V12f_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V13f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V0x
              = ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w @ V11r @ V12f_27 @ V13f0 ) )
            & ( ( V7f1 @ V11r @ V12f_27 @ V13f0 )
              = V1v ) )
        | ? [V14r: tyop_2Ebinary__ieee_2Erounding,V15f_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V16f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V0x
              = ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w @ V14r @ V15f_27 @ V16f0 ) )
            & ( ( V6f2 @ V14r @ V15f_27 @ V16f0 )
              = V1v ) )
        | ? [V17r: tyop_2Ebinary__ieee_2Erounding,V18f_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V19f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V0x
              = ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w @ V17r @ V18f_27 @ V19f0 ) )
            & ( ( V5f3 @ V17r @ V18f_27 @ V19f0 )
              = V1v ) )
        | ? [V20r: tyop_2Ebinary__ieee_2Erounding,V21f_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V22f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V0x
              = ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w @ V20r @ V21f_27 @ V22f0 ) )
            & ( ( V4f4 @ V20r @ V21f_27 @ V22f0 )
              = V1v ) )
        | ? [V23r: tyop_2Ebinary__ieee_2Erounding,V24f_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V25f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V26f1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V0x
              = ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w @ V23r @ V24f_27 @ V25f0 @ V26f1_27 ) )
            & ( ( V3f5 @ V23r @ V24f_27 @ V25f0 @ V26f1_27 )
              = V1v ) )
        | ? [V27r: tyop_2Ebinary__ieee_2Erounding,V28f_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V29f0: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w,V30f1_27: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
            ( ( V0x
              = ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w @ V27r @ V28f_27 @ V29f0 @ V30f1_27 ) )
            & ( ( V2f6 @ V27r @ V28f_27 @ V29f0 @ V30f1_27 )
              = V1v ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Enum2float__compare__float__compare2num,axiom,
    ! [V0a: tyop_2Ebinary__ieee_2Efloat__compare] :
      ( ( c_2Ebinary__ieee_2Enum2float__compare @ ( c_2Ebinary__ieee_2Efloat__compare2num @ V0a ) )
      = V0a ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare2num__num2float__compare,axiom,
    ! [V0r: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0r @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
    <=> ( ( c_2Ebinary__ieee_2Efloat__compare2num @ ( c_2Ebinary__ieee_2Enum2float__compare @ V0r ) )
        = V0r ) ) ).

thf(thm_2Ebinary__ieee_2Enum2float__compare__11,axiom,
    ! [V0r: tyop_2Enum_2Enum,V1r_27: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0r @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
     => ( ( c_2Eprim__rec_2E_3C @ V1r_27 @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
       => ( ( ( c_2Ebinary__ieee_2Enum2float__compare @ V0r )
            = ( c_2Ebinary__ieee_2Enum2float__compare @ V1r_27 ) )
        <=> ( V0r = V1r_27 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare2num__11,axiom,
    ! [V0a: tyop_2Ebinary__ieee_2Efloat__compare,V1a_27: tyop_2Ebinary__ieee_2Efloat__compare] :
      ( ( ( c_2Ebinary__ieee_2Efloat__compare2num @ V0a )
        = ( c_2Ebinary__ieee_2Efloat__compare2num @ V1a_27 ) )
    <=> ( V0a = V1a_27 ) ) ).

thf(thm_2Ebinary__ieee_2Enum2float__compare__ONTO,axiom,
    ! [V0a: tyop_2Ebinary__ieee_2Efloat__compare] :
    ? [V1r: tyop_2Enum_2Enum] :
      ( ( V0a
        = ( c_2Ebinary__ieee_2Enum2float__compare @ V1r ) )
      & ( c_2Eprim__rec_2E_3C @ V1r @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare2num__ONTO,axiom,
    ! [V0r: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0r @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
    <=> ? [V1a: tyop_2Ebinary__ieee_2Efloat__compare] :
          ( V0r
          = ( c_2Ebinary__ieee_2Efloat__compare2num @ V1a ) ) ) ).

thf(thm_2Ebinary__ieee_2Enum2float__compare__thm,axiom,
    ( ( ( c_2Ebinary__ieee_2Enum2float__compare @ c_2Enum_2E0 )
      = c_2Ebinary__ieee_2ELT )
    & ( ( c_2Ebinary__ieee_2Enum2float__compare @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
      = c_2Ebinary__ieee_2EEQ )
    & ( ( c_2Ebinary__ieee_2Enum2float__compare @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) )
      = c_2Ebinary__ieee_2EGT )
    & ( ( c_2Ebinary__ieee_2Enum2float__compare @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      = c_2Ebinary__ieee_2EUN ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare2num__thm,axiom,
    ( ( ( c_2Ebinary__ieee_2Efloat__compare2num @ c_2Ebinary__ieee_2ELT )
      = c_2Enum_2E0 )
    & ( ( c_2Ebinary__ieee_2Efloat__compare2num @ c_2Ebinary__ieee_2EEQ )
      = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
    & ( ( c_2Ebinary__ieee_2Efloat__compare2num @ c_2Ebinary__ieee_2EGT )
      = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) )
    & ( ( c_2Ebinary__ieee_2Efloat__compare2num @ c_2Ebinary__ieee_2EUN )
      = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__EQ__float__compare,axiom,
    ! [V0a: tyop_2Ebinary__ieee_2Efloat__compare,V1a_27: tyop_2Ebinary__ieee_2Efloat__compare] :
      ( ( V0a = V1a_27 )
    <=> ( ( c_2Ebinary__ieee_2Efloat__compare2num @ V0a )
        = ( c_2Ebinary__ieee_2Efloat__compare2num @ V1a_27 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__case__def,axiom,
    ! [A_27a: $tType] :
      ( ! [V0v0: A_27a,V1v1: A_27a,V2v2: A_27a,V3v3: A_27a] :
          ( ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a @ c_2Ebinary__ieee_2ELT @ V0v0 @ V1v1 @ V2v2 @ V3v3 )
          = V0v0 )
      & ! [V4v0: A_27a,V5v1: A_27a,V6v2: A_27a,V7v3: A_27a] :
          ( ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a @ c_2Ebinary__ieee_2EEQ @ V4v0 @ V5v1 @ V6v2 @ V7v3 )
          = V5v1 )
      & ! [V8v0: A_27a,V9v1: A_27a,V10v2: A_27a,V11v3: A_27a] :
          ( ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a @ c_2Ebinary__ieee_2EGT @ V8v0 @ V9v1 @ V10v2 @ V11v3 )
          = V10v2 )
      & ! [V12v0: A_27a,V13v1: A_27a,V14v2: A_27a,V15v3: A_27a] :
          ( ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a @ c_2Ebinary__ieee_2EUN @ V12v0 @ V13v1 @ V14v2 @ V15v3 )
          = V15v3 ) ) ).

thf(thm_2Ebinary__ieee_2Edatatype__float__compare,axiom,
    ! [V0float__compare: tyop_2Ebinary__ieee_2Efloat__compare > tyop_2Ebinary__ieee_2Efloat__compare > tyop_2Ebinary__ieee_2Efloat__compare > tyop_2Ebinary__ieee_2Efloat__compare > $o] : ( c_2Ebool_2EDATATYPE @ $o @ ( V0float__compare @ c_2Ebinary__ieee_2ELT @ c_2Ebinary__ieee_2EEQ @ c_2Ebinary__ieee_2EGT @ c_2Ebinary__ieee_2EUN ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__distinct,axiom,
    ( ( (~) @ ( c_2Ebinary__ieee_2ELT = c_2Ebinary__ieee_2EEQ ) )
    & ( (~) @ ( c_2Ebinary__ieee_2ELT = c_2Ebinary__ieee_2EGT ) )
    & ( (~) @ ( c_2Ebinary__ieee_2ELT = c_2Ebinary__ieee_2EUN ) )
    & ( (~) @ ( c_2Ebinary__ieee_2EEQ = c_2Ebinary__ieee_2EGT ) )
    & ( (~) @ ( c_2Ebinary__ieee_2EEQ = c_2Ebinary__ieee_2EUN ) )
    & ( (~) @ ( c_2Ebinary__ieee_2EGT = c_2Ebinary__ieee_2EUN ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__nchotomy,axiom,
    ! [V0a: tyop_2Ebinary__ieee_2Efloat__compare] :
      ( ( V0a = c_2Ebinary__ieee_2ELT )
      | ( V0a = c_2Ebinary__ieee_2EEQ )
      | ( V0a = c_2Ebinary__ieee_2EGT )
      | ( V0a = c_2Ebinary__ieee_2EUN ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__Axiom,axiom,
    ! [A_27a: $tType,V0x0: A_27a,V1x1: A_27a,V2x2: A_27a,V3x3: A_27a] :
    ? [V4f: tyop_2Ebinary__ieee_2Efloat__compare > A_27a] :
      ( ( ( V4f @ c_2Ebinary__ieee_2ELT )
        = V0x0 )
      & ( ( V4f @ c_2Ebinary__ieee_2EEQ )
        = V1x1 )
      & ( ( V4f @ c_2Ebinary__ieee_2EGT )
        = V2x2 )
      & ( ( V4f @ c_2Ebinary__ieee_2EUN )
        = V3x3 ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__induction,axiom,
    ! [V0P: tyop_2Ebinary__ieee_2Efloat__compare > $o] :
      ( ( ( V0P @ c_2Ebinary__ieee_2EEQ )
        & ( V0P @ c_2Ebinary__ieee_2EGT )
        & ( V0P @ c_2Ebinary__ieee_2ELT )
        & ( V0P @ c_2Ebinary__ieee_2EUN ) )
     => ! [V1a: tyop_2Ebinary__ieee_2Efloat__compare] : ( V0P @ V1a ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__case__cong,axiom,
    ! [A_27a: $tType,V0v3_27: A_27a,V1v2_27: A_27a,V2v1_27: A_27a,V3v0_27: A_27a,V4M: tyop_2Ebinary__ieee_2Efloat__compare,V5M_27: tyop_2Ebinary__ieee_2Efloat__compare,V6v0: A_27a,V7v1: A_27a,V8v2: A_27a,V9v3: A_27a] :
      ( ( ( V4M = V5M_27 )
        & ( ( V5M_27 = c_2Ebinary__ieee_2ELT )
         => ( V6v0 = V3v0_27 ) )
        & ( ( V5M_27 = c_2Ebinary__ieee_2EEQ )
         => ( V7v1 = V2v1_27 ) )
        & ( ( V5M_27 = c_2Ebinary__ieee_2EGT )
         => ( V8v2 = V1v2_27 ) )
        & ( ( V5M_27 = c_2Ebinary__ieee_2EUN )
         => ( V9v3 = V0v3_27 ) ) )
     => ( ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a @ V4M @ V6v0 @ V7v1 @ V8v2 @ V9v3 )
        = ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a @ V5M_27 @ V3v0_27 @ V2v1_27 @ V1v2_27 @ V0v3_27 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__compare__case__eq,axiom,
    ! [A_27a: $tType,V0x: tyop_2Ebinary__ieee_2Efloat__compare,V1v3: A_27a,V2v2: A_27a,V3v1: A_27a,V4v0: A_27a,V5v: A_27a] :
      ( ( ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a @ V0x @ V4v0 @ V3v1 @ V2v2 @ V1v3 )
        = V5v )
    <=> ( ( ( V0x = c_2Ebinary__ieee_2ELT )
          & ( V4v0 = V5v ) )
        | ( ( V0x = c_2Ebinary__ieee_2EEQ )
          & ( V3v1 = V5v ) )
        | ( ( V0x = c_2Ebinary__ieee_2EGT )
          & ( V2v2 = V5v ) )
        | ( ( V0x = c_2Ebinary__ieee_2EUN )
          & ( V1v3 = V5v ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Ezero__lt__twopow,axiom,
    ! [V0n: tyop_2Enum_2Enum] : ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V0n ) ) ).

thf(thm_2Ebinary__ieee_2Ezero__le__twopow,axiom,
    ! [V0n: tyop_2Enum_2Enum] : ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V0n ) ) ).

thf(thm_2Ebinary__ieee_2Ezero__neq__twopow,axiom,
    ! [V0n: tyop_2Enum_2Enum] :
      ( (~)
      @ ( ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V0n )
        = ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ebinary__ieee_2Ezero__le__pos__div__twopow,axiom,
    ! [V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] : ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Ereal__of__num @ V0m ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V1n ) ) ) ).

thf(thm_2Ebinary__ieee_2Ediv__eq0,axiom,
    ! [V0a: tyop_2Erealax_2Ereal,V1b: tyop_2Erealax_2Ereal] :
      ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V1b )
     => ( ( ( c_2Ereal_2E_2F @ V0a @ V1b )
          = ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
      <=> ( V0a
          = ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eexp__ge2,axiom,
    ! [V0b: tyop_2Enum_2Enum] :
      ( ( c_2Earithmetic_2E_3C_3D @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2EEXP @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ V0b ) )
      = ( c_2Earithmetic_2E_3C_3D @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ V0b ) ) ).

thf(thm_2Ebinary__ieee_2Eexp__gt2,axiom,
    ! [V0b: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2EEXP @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ V0b ) )
      = ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ V0b ) ) ).

thf(thm_2Ebinary__ieee_2Ele2,axiom,
    ! [V0n: tyop_2Erealax_2Ereal,V1m: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V0n )
        & ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V1m ) )
     => ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Erealax_2Ereal__mul @ V0n @ V1m ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__components,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27c: $tType,A_27d: $tType,A_27e: $tType,A_27f: $tType,A_27g: $tType,A_27h: $tType,A_27i: $tType,A_27j: $tType,A_27t: $tType,A_27w: $tType] :
      ( ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2Eword__T @ A_27w ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ A_27t @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2Eword__T @ A_27w ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ A_27t @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ A_27t @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ A_27t @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ A_27t @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ A_27w @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ A_27t @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2Eword__sub @ A_27w @ ( c_2Ewords_2Eword__T @ A_27w ) @ ( c_2Ewords_2En2w @ A_27w @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2Eword__T @ A_27t ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2En2w @ tyop_2Eone_2Eone @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2Eword__sub @ A_27w @ ( c_2Ewords_2Eword__T @ A_27w ) @ ( c_2Ewords_2En2w @ A_27w @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2Eword__T @ A_27t ) )
      & ! [V0fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27a @ A_27b] :
          ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b @ V0fp__op ) )
          = ( c_2Ewords_2Eword__T @ A_27b ) )
      & ! [V1fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27c @ A_27d] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27c @ A_27d @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27c @ A_27d @ V1fp__op ) )
            = ( c_2Ewords_2En2w @ A_27c @ c_2Enum_2E0 ) ) )
      & ! [V2x: tyop_2Ebinary__ieee_2Efloat @ A_27e @ A_27f] :
          ( ( c_2Ebinary__ieee_2Efloat__Sign @ A_27e @ A_27f @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27e @ A_27f @ V2x ) )
          = ( c_2Ewords_2Eword__1comp @ tyop_2Eone_2Eone @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27e @ A_27f @ V2x ) ) )
      & ! [V3x: tyop_2Ebinary__ieee_2Efloat @ A_27g @ A_27h] :
          ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27g @ A_27h @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27g @ A_27h @ V3x ) )
          = ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27g @ A_27h @ V3x ) )
      & ! [V4x: tyop_2Ebinary__ieee_2Efloat @ A_27i @ A_27j] :
          ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27i @ A_27j @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27i @ A_27j @ V4x ) )
          = ( c_2Ebinary__ieee_2Efloat__Significand @ A_27i @ A_27j @ V4x ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__distinct,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27t: $tType,A_27w: $tType] :
      ( ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ! [V0fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
            = ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ V0fp__op ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ! [V1fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
            = ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ V1fp__op ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ! [V2fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
            = ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ V2fp__op ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ! [V3fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
            = ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ V3fp__op ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ! [V4fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
            = ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ V4fp__op ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ! [V5fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
            = ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ V5fp__op ) ) )
      & ! [V6fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
            = ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ V6fp__op ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
          = ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ! [V7fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
            = ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w @ V7fp__op ) ) )
      & ! [V8x: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
          ( (~)
          @ ( ( c_2Ebinary__ieee_2Efloat__negate @ A_27a @ A_27b @ V8x )
            = V8x ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__values,axiom,
    ! [A_27a: $tType,A_27b: $tType,A_27t: $tType,A_27w: $tType] :
      ( ( ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = c_2Ebinary__ieee_2EInfinity )
      & ( ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = c_2Ebinary__ieee_2EInfinity )
      & ! [V0fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27a @ A_27b] :
          ( ( c_2Ebinary__ieee_2Efloat__value @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b @ V0fp__op ) )
          = c_2Ebinary__ieee_2ENaN )
      & ( ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ebinary__ieee_2EFloat @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ebinary__ieee_2EFloat @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ebinary__ieee_2EFloat @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ewords_2EINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) @ ( c_2Efcp_2Edimindex @ A_27t @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ebinary__ieee_2EFloat @ ( c_2Ereal_2E_2F @ ( c_2Erealax_2Ereal__neg @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Ewords_2EINT__MAX @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) ) @ ( c_2Efcp_2Edimindex @ A_27t @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Ezero__to__real,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
      & ( ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ebinary__ieee_2Esign__not__zero,axiom,
    ! [V0s: tyop_2Efcp_2Ecart @ $o @ tyop_2Eone_2Eone] :
      ( (~)
      @ ( ( c_2Ereal_2Epow @ ( c_2Erealax_2Ereal__neg @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Ewords_2Ew2n @ tyop_2Eone_2Eone @ V0s ) )
        = ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__sets,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w )
        = ( c_2Epred__set_2EINSERT @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Epred__set_2EINSERT @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Epred__set_2EEMPTY @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w )
        = ( c_2Epred__set_2EINSERT @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Epred__set_2EINSERT @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) @ ( c_2Epred__set_2EEMPTY @ ( tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Einfinity__properties,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Ezero__properties,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Esome__nan__properties,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0fp__op: tyop_2Ebinary__ieee_2Efp__op @ A_27a @ A_27b] :
      ( ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b @ V0fp__op ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b @ V0fp__op ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b @ V0fp__op ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b @ V0fp__op ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__signalling @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b @ V0fp__op ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b @ V0fp__op ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b @ V0fp__op ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b @ V0fp__op ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Emin__properties,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      <=> ( ( ( c_2Efcp_2Edimindex @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) )
            = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
          & ( ( c_2Efcp_2Edimindex @ A_27t @ ( c_2Ebool_2Ethe__value @ A_27t ) )
            = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      <=> ( ( ( c_2Efcp_2Edimindex @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) )
            = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
          & ( ( c_2Efcp_2Edimindex @ A_27t @ ( c_2Ebool_2Ethe__value @ A_27t ) )
            = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Etop__properties,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      <=> ( (~)
          @ ( ( c_2Efcp_2Edimindex @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) )
            = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      <=> ( ( c_2Efcp_2Edimindex @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) )
          = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Ebottom__properties,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      <=> ( (~)
          @ ( ( c_2Efcp_2Edimindex @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) )
            = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      <=> ( ( c_2Efcp_2Edimindex @ A_27w @ ( c_2Ebool_2Ethe__value @ A_27w ) )
          = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      & ( (~) @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__zero,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
      ( ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b @ V0x )
    <=> ( ( ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27a @ A_27b @ V0x )
          = ( c_2Ewords_2En2w @ A_27b @ c_2Enum_2E0 ) )
        & ( ( c_2Ebinary__ieee_2Efloat__Significand @ A_27a @ A_27b @ V0x )
          = ( c_2Ewords_2En2w @ A_27a @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__finite,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
      ( ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27a @ A_27b @ V0x )
    <=> ( ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b @ V0x )
        | ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b @ V0x )
        | ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b @ V0x ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__cases__finite,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
      ( ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b @ V0x )
      | ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b @ V0x )
      | ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27a @ A_27b @ V0x ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__distinct__finite,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
      ( ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27a @ A_27b @ V0x ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__cases,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
      ( ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b @ V0x )
      | ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b @ V0x )
      | ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b @ V0x )
      | ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b @ V0x )
      | ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b @ V0x ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__is__distinct,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
      ( ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b @ V0x ) ) )
      & ( (~)
        @ ( ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b @ V0x )
          & ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b @ V0x ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__infinities,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w @ V0x )
    <=> ( ( V0x
          = ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        | ( V0x
          = ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__infinities__distinct,axiom,
    ! [A_27t: $tType,A_27w: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27t @ A_27w] :
      ( (~)
      @ ( ( V0x
          = ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        & ( V0x
          = ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__to__real__negate,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
      ( ( c_2Ebinary__ieee_2Efloat__to__real @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27a @ A_27b @ V0x ) )
      = ( c_2Erealax_2Ereal__neg @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27a @ A_27b @ V0x ) ) ) ).

thf(thm_2Ebinary__ieee_2Efloat__negate__negate,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0x: tyop_2Ebinary__ieee_2Efloat @ A_27a @ A_27b] :
      ( ( c_2Ebinary__ieee_2Efloat__negate @ A_27a @ A_27b @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27a @ A_27b @ V0x ) )
      = V0x ) ).

thf(thm_2Ebinary__ieee_2Eulp,axiom,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Ebinary__ieee_2Eulp @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ).

thf(thm_2Ebinary__ieee_2Eneg__ulp,conjecture,
    ! [A_27t: $tType,A_27w: $tType] :
      ( ( c_2Erealax_2Ereal__neg @ ( c_2Ebinary__ieee_2Eulp @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      = ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w @ ( c_2Ebool_2Ethe__value @ ( tyop_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
